#include "CmdTimeOnAir.h"

CmdTimeOnAir::CmdTimeOnAir(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Time on air", "AT+TOA", "Get time in ms of packet tx with current datarate"),
  _serial(serial) {
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0-242)";
    _queryable = true;
}

uint32_t CmdTimeOnAir::action(std::vector<std::string> args) {

    if (_dot->getVerbose())
        _serial.writef("Time on air: ");

    uint16_t bytes;

    sscanf(args[1].c_str(), "%hu", &bytes);

    _serial.writef("%lu\r\n", _dot->getTimeOnAir(bytes + 13));

    return 0;
}

bool CmdTimeOnAir::verify(std::vector<std::string> args) {

    if (args.size() < 2) {
        setErrorMessage("Invalid parameter, expects (0-242)");
        return false;
    }

    uint16_t bytes;

    sscanf(args[1].c_str(), "%hu", &bytes);

    if (bytes > 242) {
        setErrorMessage("Invalid parameter, expects (0-242)");
        return false;
    }

    return true;
}
