#include "CmdSerialWakeInterval.h"

CmdSerialWakeInterval::CmdSerialWakeInterval(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Serial Wake Interval", "AT+SDWI", "Serial data wakeup interval to generate wake signal (seconds)"),
        _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(2-2147483647) s";
    _queryable = true;
}

uint32_t CmdSerialWakeInterval::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("%s: ", name());

        _serial.writef("%lu\r\n", _dot->getSerialWakeInterval());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        uint32_t timeout;
        sscanf(args[1].c_str(), "%lu", &timeout);

        if ((code = _dot->setSerialWakeInterval(timeout)) != mDot::MDOT_OK) {
            std::string error = mDot::getReturnCodeString(code) + " - " + _dot->getLastError();
            setErrorMessage(error);
            return 1;
        }
    }

    return 0;
}

bool CmdSerialWakeInterval::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;
    
    if (args.size() == 2) {
        uint32_t timeout;
        if (sscanf(args[1].c_str(), "%lu", &timeout) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        if (timeout < 2 || timeout > INT_MAX) {
            setErrorMessage("Invalid interval, expects (2-2147483647) s");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
