#include "CmdSendString.h"
#include "CommandTerminal.h"

CmdSendString::CmdSendString(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Send Once", "AT+SEND", "Sends supplied packet data one time and return response, (max:242 bytes)"),
  _serial(serial) {
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(string:242)";
}

uint32_t CmdSendString::action(std::vector<std::string> args) {
    // Argument had been split on each comma, rebuild payload
    int32_t code;
    std::string text;
    for (size_t i = 1; i < args.size(); i++) {
        text.append(args[i]);
        if (i != args.size() - 1)
            text.append(",");
    }

    std::vector<uint8_t> data(text.begin(), text.end());
    if ((code = _dot->send(data, _dot->getTxWait())) != mDot::MDOT_OK) {
        std::string error = mDot::getReturnCodeString(code);

        if (code != mDot::MDOT_NOT_JOINED)
            error +=  + " - " + _dot->getLastError();

        setErrorMessage(error);
        return 1;
    }

    if (_dot->getTxWait()) {
        data.clear();

        if (_dot->recv(data) == mDot::MDOT_OK) {
            if (!data.empty()) {
                if (_dot->getVerbose())
                    _serial.writef("Packet data:\r\n");
                _serial.writef("%s\r\n", CommandTerminal::formatPacketData(data, _dot->getRxOutput()).c_str());
            }
        }
    }

    return 0;
}

bool CmdSendString::verify(std::vector<std::string> args) {

    if (args.size() == 1) {
        // allow sending empty packet to retrieve downstream messages
        return true;
    }

    if (args.size() >= 2) {
        size_t size = 0;
        for (int i = 1; i < args.size(); i++)
            size += args[i].size();
        if (size > 242) {
            setErrorMessage("Invalid packet, expects (string:242)");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
