#include "CmdRxFrequency.h"

CmdRxFrequency::CmdRxFrequency(mDot* dot, mts::MTSSerial& serial) :
    Command(dot, "Rx Frequency", "AT+RXF", "Set the Rx frequency for +RECV,+RECVC"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    if (_dot->getFrequencyBand() == mDot::FB_868)
        _usage = "(0,863000000-870000000)";
    else
        _usage = "(0,902000000-928000000)";
    _queryable = true;
}

uint32_t CmdRxFrequency::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Rx Frequency: ");

        _serial.writef("%lu\r\n", _dot->getRxFrequency());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        uint32_t frequency = 0;
        sscanf(args[1].c_str(), "%lu", &frequency);
        if ((code = _dot->setRxFrequency(frequency)) != mDot::MDOT_OK)
        {
            std::string error = mDot::getReturnCodeString(code) + " - " + _dot->getLastError();
            setErrorMessage(error);
            return 1;
        }
    }

    return 0;
}

bool CmdRxFrequency::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        uint32_t frequency;
        if (sscanf(args[1].c_str(), "%lu", &frequency) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        DEBUG_PRINTF("FREQ MIN: %lu MAX: %lu\r\n", _dot->getMinFrequency(), _dot->getMaxFrequency());

        if (frequency != 0 && (frequency < _dot->getMinFrequency() || frequency > _dot->getMaxFrequency())) {
            if (_dot->getFrequencyBand() == mDot::FB_868)
                setErrorMessage("Invalid timeout, expects (0,863000000-870000000)"); 
            else
                setErrorMessage("Invalid timeout, expects (0,902000000-928000000)");

            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
