#include "CmdJoinRetries.h"

CmdJoinRetries::CmdJoinRetries(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Join Retries", "AT+JR", "Number of times to retry joining the network in an attempt (0 - 255)"),
  _serial(serial) {
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0-255)";
    _queryable = true;
}

uint32_t CmdJoinRetries::action(std::vector<std::string> args) {
    if (args.size() == 1) {
        if (_dot->getVerbose())
            _serial.writef("Join Retries: ");

        _serial.writef("%u\r\n", _dot->getJoinRetries());
    } else if (args.size() == 2) {
        int32_t code;
        uint32_t retries;
        sscanf(args[1].c_str(), "%lu", &retries);

        if ((code = _dot->setJoinRetries(retries)) != mDot::MDOT_OK) {
            std::string error = mDot::getReturnCodeString(code) + " - " + _dot->getLastError();
            setErrorMessage(error);
            return 1;
        }
    }
    return 0;
}

bool CmdJoinRetries::verify(std::vector<std::string> args) {
    if (args.size() == 1)
        return true;

    if (args.size() == 2) {

        uint32_t retries;
        if (sscanf(args[1].c_str(), "%lu", &retries) == 1) {
            if (retries > 255) {
                setErrorMessage("Invalid retries, expects (0-255)");
                return false;
            }
            return true;
        }
    }

    setErrorMessage("Invalid arguments");
    return false;
}

