#include "CmdACKAttempts.h"

CmdACKAttempts::CmdACKAttempts(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Require ACK", "AT+ACK", "Enable to require send acknowledgement (0: off, N: number of attempts until ACK recevied)"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0-8)";
    _queryable = true;
}

uint32_t CmdACKAttempts::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("ACK Attempts: ");

        _serial.writef("%u\r\n", _dot->getAck());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        uint32_t retries;
        sscanf(args[1].c_str(), "%lu", &retries);

        if ((code = _dot->setAck(retries)) != mDot::MDOT_OK)
        {
            std::string error = mDot::getReturnCodeString(code) + " - " + _dot->getLastError();
            setErrorMessage(error);
            return 1;
        }
    }

    return 0;
}

bool CmdACKAttempts::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        uint32_t retries;
        if (sscanf(args[1].c_str(), "%lu", &retries) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        if (retries > 8) {
            setErrorMessage("Invalid attempts, expects (0-8)");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
