#include "CmdSerialWakeDelay.h"

CmdSerialWakeDelay::CmdSerialWakeDelay(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Serial Wake Delay", "AT+SDWD", "Time to wait for data after wakeup signal  (milliseconds)"),
        _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(2-2147483647) ms";
    _queryable = true;
}

uint32_t CmdSerialWakeDelay::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("%s: ", name());

        _serial.writef("%lu\r\n", _dot->getSerialWakeDelay());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        uint32_t delay;
        sscanf(args[1].c_str(), "%lu", &delay);

        if ((code = _dot->setSerialWakeDelay(delay)) != mDot::MDOT_OK) {
            std::string error = mDot::getReturnCodeString(code) + " - " + _dot->getLastError();
            setErrorMessage(error);
            return 1;
        }
    }

    return 0;
}

bool CmdSerialWakeDelay::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        uint32_t delay;
        if (sscanf(args[1].c_str(), "%lu", &delay) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        if (delay < 2 || delay > INT_MAX) {
            setErrorMessage("Invalid delay, expects (2-2147483647) ms");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
