#include "CmdSerialReceiveTimeout.h"

CmdSerialReceiveTimeout::CmdSerialReceiveTimeout(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Serial Receive Timeout", "AT+SDTO", "Read serial data until timeout (milliseconds)"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0-65000) ms";
    _queryable = true;
}

uint32_t CmdSerialReceiveTimeout::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("%s: ", name());

        _serial.writef("%lu\r\n", _dot->getSerialReceiveTimeout());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        uint32_t timeout;
        sscanf(args[1].c_str(), "%lu", &timeout);

        if ((code = _dot->setSerialReceiveTimeout(timeout)) != mDot::MDOT_OK) {
            std::string error = mDot::getReturnCodeString(code) + " - " + _dot->getLastError();
            setErrorMessage(error);
            return 1;
        }
    }

    return 0;
}

bool CmdSerialReceiveTimeout::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        uint32_t timeout;
        if (sscanf(args[1].c_str(), "%lu", &timeout) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        if (timeout < 0 || timeout > 65000) {
            setErrorMessage("Invalid timeout, expects (0-65000) ms");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
