#include "CmdSendStringHighBW.h"
#include "CommandTerminal.h"

CmdSendStringHighBW::CmdSendStringHighBW(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Send Once High BW", "AT+SENDH", "Sends supplied packet data one time and return response using High Bandwidth channel, (max:242 bytes)"),
  _serial(serial) {
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(string:242)";
}

uint32_t CmdSendStringHighBW::action(std::vector<std::string> args) {
    // Argument had been split on each comma, rebuild payload
    int32_t code;
    std::string text;
    for (size_t i = 1; i < args.size(); i++) {
        text.append(args[i]);
        if (i != args.size() - 1)
            text.append(",");
    }

    std::vector<uint8_t> data(text.begin(), text.end());
    if ((code = _dot->send(data, _dot->getTxWait(), true)) != mDot::MDOT_OK) {
        std::string error = mDot::getReturnCodeString(code);

        if (code != mDot::MDOT_NOT_JOINED)
            error +=  + " - " + _dot->getLastError();

        setErrorMessage(error);
        return 1;
    }

    data.clear();

    if (_dot->getTxWait() && _dot->recv(data) == mDot::MDOT_OK) {
        if (!data.empty()) {
            if (_dot->getVerbose())
                _serial.writef("Packet data:\r\n");
            _serial.writef("%s\r\n", CommandTerminal::formatPacketData(data, _dot->getRxOutput()).c_str());
        }
    }

    return 0;
}

bool CmdSendStringHighBW::verify(std::vector<std::string> args) {
    if (args.size() == 2) {
        if (args[1].size() > 242) {
            setErrorMessage("Invalid packet, expects (string:242)");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
