#include "CmdRxOutput.h"

CmdRxOutput::CmdRxOutput(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Rx Output", "AT+RXO", "Set the Rx output type (0:hexadecimal, 1:raw)"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0,1)";
    _queryable = true;
}

uint32_t CmdRxOutput::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Rx Output: ");

        _serial.writef("%u\r\n", _dot->getRxOutput());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        uint8_t output = args[1] == "0" ? 0 : 1;
        if ((code = _dot->setRxOutput(output)) != mDot::MDOT_OK)
        {
            std::string error = mDot::getReturnCodeString(code) + " - " + _dot->getLastError();
            setErrorMessage(error);
            return 1;
        }
    }

    return 0;
}

bool CmdRxOutput::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        if (!(args[1] == "0" || args[1] == "1")) {
            setErrorMessage("Invalid type, expects (0:hexadecimal, 1:raw)");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
