#include "CmdRssi.h"

CmdRssi::CmdRssi(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Signal Strength", "AT+RSSI", "Displays signal strength information for received packets: last, min, max, avg"),
        _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(-140-0),(-140-0),(-140-0),(-140-0)";
    _queryable = true;
}

uint32_t CmdRssi::action(std::vector<std::string> args)
{
    mDot::rssi_stats stats = _dot->getRssiStats();

    if (_dot->getVerbose())
        _serial.writef("RSSI stats: ");

    _serial.writef("%d, %d, %d, %d\r\n", stats.last, stats.min, stats.max, stats.avg);

    return 0;
}

