#include "CmdLinkCheckThreshold.h"

CmdLinkCheckThreshold::CmdLinkCheckThreshold(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Link Check Threshold", "AT+LCT", "Set threshold for number of link check of ACK failures to tolerate, (0: off, N: number of failures"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0-255)";
    _queryable = true;
}

uint32_t CmdLinkCheckThreshold::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Link Check Threshold: ");

        _serial.writef("%u\r\n", _dot->getLinkCheckThreshold());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        uint32_t count;
        sscanf(args[1].c_str(), "%lu", &count);

        if ((code = _dot->setLinkCheckThreshold(count)) != mDot::MDOT_OK)
        {
            std::string error = mDot::getReturnCodeString(code) + " - " + _dot->getLastError();
            setErrorMessage(error);
            return 1;
        }
    }

    return 0;
}

bool CmdLinkCheckThreshold::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        uint32_t count;
        sscanf(args[1].c_str(), "%lu", &count);

        if (count > 255) {
            setErrorMessage("Invalid count, expects (0-255))");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
