#include "irpair.h"
#include "mbed.h"

#define dark_samples 10
#define busy_wait 10

void IRPair::calibrateSensor() {

    ir.write( 1 );
    wait_us(60);

    for (int i = 0; i < samplesToTake; ++i) 
        sensorAvg += recv.read();
        
    ir.write( 0 );
    sensorAvg /= samplesToTake;
    wait_us(5);
}

double IRPair::getSamples( int samples )
{
    double z = 0;
    
    ir.write( 0 );
    //for( int i = 0; i < dark_samples; i++ )
    //    z1 += recv.read();
    
    ir.write( 1 );
    wait_us(60);
    
    for( int i = 0; i < samples; ++i )
        z += recv.read();
    ir.write( 0 );
    wait_us(5);
    return z / samples;
}