#include "mbed.h"
#include "motor.h"

void Motor::backward(double voltage) {
    if(voltage > maxSpeed){
        voltage = maxSpeed;
    }else if(voltage < minSpeed){
        voltage = minSpeed;
    }
    enableForw.write(0);
    enableBack.write(1);
    motorSpeed.write( voltage );
}

void Motor::forward(double voltage) {
    if(voltage > maxSpeed){
        voltage = maxSpeed;
    }else if(voltage < minSpeed){
        voltage = minSpeed;
    }
    enableForw.write(1);
    enableBack.write(0);
    motorSpeed.write( voltage );
}

void Motor::move(double voltage) {
    if(voltage < 0){
        backward(-voltage);
    }
    if(voltage > 0){
        forward(voltage);
    }
}


void Motor::brake() {
    enableForw.write(1);
    enableBack.write(1);
    motorSpeed.write( BRAKE_VOLTAGE );
}

void Motor::coast() {
    enableForw.write(0);
    enableBack.write(0);
    motorSpeed.write( 0 );
}