#include "mbed.h"
#include "MODSERIAL.h"

Ticker output;

AnalogIn pot(A0);
DigitalOut led_r (LED_RED); 
DigitalOut led_g (LED_GREEN);  
DigitalOut led_b (LED_BLUE); 

MODSERIAL pc(USBTX, USBRX);
const int baudrate = 115200;            // Baudrate voor seriële verbinding
const int output_rate = 1000;

bool fn_go = false;

void serial_output()
{
    fn_go = true;
    led_r.write(false);
    
}

int main()
{
    led_r.write(true);
    led_g.write(false);    
    led_b.write(true);     
    output.attach_us(&serial_output,output_rate)    ;
    pc.baud(baudrate);
    while (true) {
        led_b.write(false);  
        
        if(fn_go) {
            led_g.write(true);            
            float pot_val = pot.read();
            pot_val = pot_val*4 - 2;
            pc.printf("Potmeter value %.2f \n",pot_val);
            
            fn_go = false;
        }
    }
}