//Los comentarios son todos mios. Saqué los de Dani pero podés verlos en su código. Agunas cosas las dejé porque me sirvieron.

#include "mbed.h"
//#include "mi_lora.h"
#include "medir_frecuencia.h"

#define MI_ADC_PERIODO_MS 2000  //cada 2 segundos tomo muestras
#define CLOCK 32    //frec del micro en MHZ


Serial pc(USBTX, USBRX); //115200 baud rate

uint16_t muestras[N_MUESTRAS];

void funcion_calcularFrec (void)
{
    AnalogIn mi_adc(GPIO1);
    unsigned int i, for_time, total_time, operation_time;
    float tiempo_muestreo,frecuencia;
    Timer timer;

    // calculo cuanto se demora en hacer el ciclo for. En realidad esto está al pedo y podría sacarse.
    timer.reset();
    timer.start();
    for (i=0; i<N_MUESTRAS; i++);
    for_time=timer.read_us();
    timer.stop();

    while(1)
    {
        thread_sleep_for(MI_ADC_PERIODO_MS); //Cada cuánto tomo las muestras.
        // primero tomo las muetras
        timer.reset();
        timer.start();
        for(i=0;i<N_MUESTRAS;i++)
        {
            muestras[i]=(uint16_t) (ADC_RES_Cuentas*mi_adc.read());
        }
        total_time=timer.read_us();
        timer.stop();
        operation_time = total_time-for_time;
        tiempo_muestreo=float(operation_time)/float(N_MUESTRAS);
         //Este es el tiempo de muestreo que sale de lo que tarda en tomar una X cantidad de muestras. Para eso está el timer que está en el ciclo for.
        imprimir_datos(muestras);
        frecuencia=calcular_frecuencia(muestras,N_MUESTRAS,tiempo_muestreo);
        printf("Frec=%f[Hz] \n\r\n",frecuencia);

    }
}

int main(void)
{

    Thread tarea_calcularFrec(osPriorityNormal,OS_STACK_SIZE,NULL,"ADC" ); //Le doy un hilo, una prioridad.
    //Thread tarea_lora(osPriorityNormal,OS_STACK_SIZE,NULL,"LoRA" );
    //sem_leer_data.release();
    tarea_calcularFrec.start(funcion_calcularFrec); //se define el hilo a ejecutar (creo).
    //tarea_lora.start(funcion_lora);

    pc.baud(115200);
    printf("MAIN: Init OK\n\r"); // Esto es para chequear que está todo bien cuando reinicias el micro, lo puso dani.

    //funcion_lora();
    while(1)
    {
        thread_sleep_for(5000);
    }
    return 0;
}
