#ifndef STEPPERTB_H
#define STEPPERTB_H

#include "mbed.h"

class StepperTB {
    public:
    /*Parameterized CTOR
    *ENA = ENA-
    *DIR = DIR-
    *PUL = PUL-
    *Microstep = jumlah microstep dalam 1 step
    *StepPerRev = jumlah step dalam 1 putaran
    */
    StepperTB(PinName ENA, PinName DIR, PinName PUL, int Microstep, int StepPerRev);
    
    /*Method*/
    /*MoveStep
    *Gerakkan stepper sebanyak StepAmt step dengan
    *Selang waktu antar microstep selama Interval (dalam us)
    */
    void MoveOneStep(bool Direction, int Interval);
    
    /*MoveStep
    *Gerakkan stepper sebanyak StepAmt step dengan
    *Selang waktu antar microstep selama Interval (dalam us)
    */
    void MoveStep(int StepAmt, int Interval);
    
    /*MoveRev
    *Gerakkan stepper sejauh RevAmt putaran dengan
    *Selang waktu antar microstep selama Interval (dalam us)
    */
    void MoveRev(int RevAmt, int Interval);
    
    //Getter
    //StepPerRev
    int getSPR();
    //Microstep
    int getMstep();
    
    private:
    //Pins
    DigitalOut ENA_;
    DigitalOut DIR_;
    DigitalOut PUL_;
    
    int Microstep_;
    int StepPerRev_;

};

#endif
