#include "mbed.h"
#include "StepperTB.h"

//Parameterized CTOR
StepperTB::StepperTB(PinName ENA, PinName DIR, PinName PUL, int Microstep, int StepPerRev):
ENA_(ENA), DIR_(DIR), PUL_(PUL), Microstep_(Microstep), StepPerRev_(StepPerRev) {
    //Inisiasi saja
    }

//GETTER
int StepperTB::getSPR(){
        return StepPerRev_;
    }
    
int StepperTB::getMstep(){
        return Microstep_;
    }

//Method

void StepperTB::MoveOneStep(bool Direction, int Interval){
        int Msteps = getMstep();
        
        //Gerak sebanyak Mstep Microstep = 1 Step
        if(Direction == 0){
            //Arah 0 (Belum dicoba CW/CCW)
            for(int i=0; i<Msteps; i++){
                    DIR_=0;
                    ENA_=1;
                    PUL_=1;
                    wait_us(Interval);
                    PUL_=0;
                    wait_us(Interval);
                }
            }
        else {
            //Arah 1
            for(int i=0; i>Msteps; i--){
                    DIR_=1;
                    ENA_=1;
                    PUL_=1;
                    wait_us(Interval);
                    PUL_=0;
                    wait_us(Interval);
                }
            }
    }

void StepperTB::MoveStep(int StepAmt, int Interval){
        
        //Gerak sebanyak MstepAmt microstep
        if(StepAmt>=0){
            //Arah 0 (Belum dicoba CW/CCW)
            for(int i=0; i<StepAmt; i++){    
                    MoveOneStep(0, Interval);
                }
            }
        else {
            //Arah 1
            for(int i=0; i>StepAmt; i--){
                    MoveOneStep(1, Interval);
                }
            }
    }
    
    
void StepperTB::MoveRev(int RevAmt, int Interval){
        //Konversi RevAmt ke step
        int StepAmt = RevAmt*getSPR();
        
        //Gerak sebanyak MstepAmt microstep
        MoveStep(StepAmt, Interval);
    }