#include "mbed.h"


PwmOut ml(PA_0);                        //motor links PWMout
PwmOut mr(PA_0);                        //motor rechts PWMout
DigitalOut l(PA_0);                     //motor links vooruit/achteruit
DigitalOut r(PA_0);                     //motor rechts vooruit/achteruit
AnalogIn irl(PA_0);                     //input infraroodsensor links
AnalogIn irr(PA_0);                     //input infraroodsensor rechts
AnalogIn aml(PA_0);                     //input ultrasonesensor links
AnalogIn amr(PA_0);                     //input ultrasonesensor rechts


int msl = 100,          msr = 100,          v = 0,              a = 1,              irsl,               irsr,               amsl,           amsr,           Rijrichting;
//  maximale motor      maximale moter      v is vooruit        a is achteruit      infraroodsensor     infraroodsensor     ultrasoon       ultrasoon       een getal die de rij richting
//  snelheid links      snelheid rechts     dus als de motor    dus als de motor    links               rechts              sensor links    sensor rechts   aangeeft gedefinieerd in de
//                                          een 0 als input     een 1 als input                                                                             functie Rijrichting
//                                          krijgt moet deze    krijgt moet deze    
//                                          vooruit rijden      achteruit rijden    


void Richting(int Rijrichting)
{
    if (Rijrichting == 1)               //vooruit
    {
        l = v;
        r = v;
        ml = 1*msl;
        mr = 1*msr;
    }
    if (Rijrichting == 2)               //achteruit
    {
        l = a;
        r = a;
        ml = 1*msl;
        mr = 1*msr;
    }
    if (Rijrichting == 3)               //linksom
    {
        l = a;
        r = v;
        ml = 1*msl;
        mr = 1*msr;
    }
    if (Rijrichting == 4)               //rechtsom
    {
        l = v;
        r = a;
        ml = 1*msl;
        mr = 1*msr;
    }
    if (Rijrichting == 5)               // linksaf
    {
        l = v;
        r = v;
        ml = 0.25*msl;
        mr = 1*msr;
    }
    if (Rijrichting == 6)               //rechtsaf
    {
        l = v;
        r = v;
        ml = 1*msl;
        mr = 0.25*msr;
    }
}


int main()
{
    while(1)
    {
        if (irl >= 0.5f)                //wittelijn detectie links word verversd
        {
            irsl = 1;
        }
        else
        {
            irsl = 0;
        }


        if (irr >= 0,5)                 //wittelijn detectie rechts word verversd
        {
            irsr = 1;
        }
        else
        {
            irsr = 0;
        }


        if (aml >= 0.5f)                //afstandmeter links word verversd
        {
            amsl = 1;
        }
        else
        {
            amsl = 0;
        }


        if (amr >= 0,5)                 //afstandmeter rechts word verversd
        {
            amsr = 1;
        }
        else
        {
            amsr = 0;
        }


        if ((irsr == 1) && (irsl == 1)) //reageren op de wittelijn sensor
        {
            Rijrichting = 2;
            Richting(Rijrichting);
        }
        else if (irsl == 1)
        {
            Rijrichting = 4;
            Richting(Rijrichting);
        }
        else if (irsr == 1)
        {
            Rijrichting = 5;
            Richting(Rijrichting);
        }
        else if ((amsr == 1) && (amsl == 1)) //reageren op de afstandsmeter
        {
            Rijrichting = 1;
            Richting(Rijrichting);
        }
        else if (amsl == 1)
        {
            Rijrichting = 5;
            Richting(Rijrichting);
        }
        else if (amsr == 1)
        {
            Rijrichting = 6;
            Richting(Rijrichting);
        }
        else                                //zoeken naar andere robot zonder over de wittelijn te rijden
        {
            Rijrichting = 4;
            Richting(Rijrichting);
        }
    }
}