#ifndef PCF8523_H
#define PCF8523_H

#include "mbed.h"

#define address 0xD0

class PCF8523
{
public:
    
    enum RegisterName
    {
        // Control Register                 | Bit 7 | Bit 6 | Bit 5 | Bit 4 | Bit 3 | Bit 2 | Bit 1 | Bit 0 |
        CTRL1       = 0x00, // Ctrl 1       |Cap Sel|   T   | Stop  |  SR   | 12-24 |  SIE  |  AIE  |  CIE  |
        CTRL2       = 0x01, // Ctrl 2       | WTAF  | CTAF  | CTBF  |  SF   |   AF  | WTAIE | CTAIE | CTBIE |
        CTRL3       = 0x02, // Ctrl 3       |       PM [2:0]        |   X   |  BSF  |  BLF  | BSIE  |  BLIE |
        
        // Time and Date Register    
        SEC         = 0x03, // Second       |   OS  |                       ( 0 - 59 )                      |
        MIN         = 0x04, // Minute       |   X   |                       ( 0 - 59 )                      |
        HOUR        = 0x05, // Hour         |   X   |   X   | AM/PM |       ( 1 - 12 )                      |
                            // Hour         |   X   |   X   |               ( 0 - 23 )                      |
        DAY         = 0x06, // Day          |   X   |   X   |               ( 1 - 31 )                      |
        WDAY        = 0x07, // Day of week  |   X   |   X   |   X   |   X   |   X   |       ( 0 - 6 )       |
        MONTH       = 0x08, // month        |   X   |   X   |   X   |               ( 1 - 12 )              |
        YEAR        = 0x09, // year         |                           ( 0 - 99 )                          |
        
        // Alarm register
        MINALARM    = 0x0A, // Minute       | AEN_M |                       ( 0 - 59 )                      |
        HOURALARM   = 0x0B, // Hour         | AEN_H |   X   |               ( 0 - 23 )                      |
                            // Hour         | AEN_H |   X   | AM/PM |       ( 1 - 12 )                      |
        DAYALARM    = 0x0C, // Day          | AEN_D |   X   |               ( 1 - 31 )                      |
        WDAYALARM   = 0x0D, // Day of week  | AEN_W |   X   |   X   |   X   |   X   |       ( 0 - 6 )       |
        
        // Offset Control Register
        OFFSET      = 0x0E, // OffSet ctrl  | MODE  |                       OFFSET                          |
        
        // ClockOut adn Timer Register
        TMRCLKOUT   = 0x0F, // Timer Clk Out|  TAM  |  TBM  |           COF         |       TAC     |  TBC  |
        TIMERAFR    = 0x10, // Timer A Freq |   X   |   X   |   X   |   X   |   X   |           TAQ         |
        TIMERARG    = 0x11, // Timer A Reg  |                           T_A   [7:0]                         |
        TIMERBFR    = 0x12, // Timer B Freq |   X   |           TBW         |   X   |           TBQ         |
        TIMERBRG    = 0x13, // Timer B Reg  |                           T_B   [7:0]                         |
    };
    
    bool write(char adr, char data);
    char read(char adr);
    time_t now();
    bool set_time(time_t time);
    bool set_alarm(const struct tm &now, bool min_en=false, bool hour_en=false, bool mday_en=false);
    bool enable_alarm(bool enable=false);
    bool alarm_off(char buffer);
    bool check_alarm();
    bool IsConnected();
    bool software_reset();
    bool Initialize(char adr, uint8_t val);
    
    PCF8523(PinName scl, PinName sda);
    ~PCF8523();
    
private:
    I2C i2c;
    char data[64];
    char w[32];
    char r[32];
    
    static int bcdToDecimal(int bcd) {
        return ((bcd & 0xF0) >> 4) * 10 + (bcd & 0x0F);
    }

    static int decimalToBcd(int dec) {
        return (dec % 10) + ((dec / 10) << 4);
    }
};

#endif