#ifndef MYDEBUG_H
#define MYDEBUG_H

extern Serial dbg;

//delays
#define delay(n)    wait_ms(n) // in milisecond
#define delay_us(n) wait_us(n) // in microsecond

 // colored terminal output using ANSI escape sequences
#if 1
  #define COL(c) "\033[" c
 #else
  #define COL(c) 
 #endif
#define DEF COL("39m")
#define BLA COL("30m")
#define RED COL("31m")
#define GRE COL("32m")
#define YEL COL("33m")
#define BLU COL("34m")
#define MAG COL("35m")
#define CYA COL("36m")
#define WHY COL("37m")

void _debugPrint(const char* color, const char* format, ...)
{
    va_list args;
    va_start (args, format);
    if (color) dbg.printf(color);
    dbg.vprintf(format, args);
    if (color) dbg.printf(DEF);
    va_end (args);
}
   
#define ERROR(...)      _debugPrint(RED, __VA_ARGS__)
#define INFO(...)       _debugPrint(GRE, __VA_ARGS__)
#define TRACE(...)      _debugPrint(DEF, __VA_ARGS__)
#define TEST(...)       _debugPrint(CYA, __VA_ARGS__)
#define FLOW(...)       _debugPrint(YEL, __VA_ARGS__)
//==============================================================================

#endif // MYDEBUG_H

