#include "mbed.h"
#include "SIM5360.h"
#include "myDebug.h"
#include <string>

#define APN         "TELKOMSEL"//NULL
#define USERNAME    NULL
#define PASSWORD    NULL 

#define SERVER  "192.168.0.111"
#define PORT    80

GSM mdm(D1, D0, 115200, NULL);
Serial dbg(USBTX, USBRX);

int main()
{
    INFO("<PROGRAM START>\r\n");
    char buf[512] = "";
    
    int ret = mdm.init();
    if(ret < 0)
    {
        ERROR("Failed modem init!\r\n");
        return -1;
    }
    TRACE("Success Modem Init...\r\n");
    
    ret = mdm.registerNet();
    if(ret < 0)
    {
        ERROR("Failed register network!\r\n");
        return -1;
    }
    TRACE("Success register network...\r\n");
    
    ret = mdm.join(APN, USERNAME, PASSWORD);
    if(ret < 0)
    {
        ERROR("Failed join network!\r\n");
        return -1;
    }
    TRACE("Success Join Network...\r\n");
    
    mdm.SetBlocking();
    
    INFO("Ready to post...\r\n");
    if(!mdm.connectTCP(SERVER, PORT))
    {
        string buff;
        buff += "kirim-kirim\r\n";
        
        INFO("Sending request...\r\n");
        if(!mdm.sendTCPData(const_cast<char *>(buff.c_str()), buff.size()))
        {
            TRACE("Berhasil-berhasil...hore...hore...\r\n");
            ret = mdm.receivedTCPData(buf, sizeof(buf)-1);
            if(ret > 0)
            {
                FLOW("Socket Recv \"%*s\"\r\n", ret, buf);
                if(strstr(buf, "HTTP/1.0 200") || strstr(buf, "HTTP/1.0 201"))
                {
                    INFO("Data success\r\n");
                }
                else
                {
                    ERROR("Data failed\r\n");
                }
            }
            else
            {
                ERROR("have not return\r\n");
            }
        }
        else
        {
            ERROR("Failed to send\r\n");
        }
    }
    else
    {
        ERROR("Failed to connect\r\n");
    }
    INFO("Disconnect...\r\rn");
    mdm.closeTCP();
    mdm.disconnect();
    wait_ms(5000);
    
    while(true)
    {
        
    }
}