#include "mbed.h"
#include "PCF85263AT.h"

Serial dbg(USBTX, USBRX);
PCF85263AT rtc(D14, D15);
DigitalOut led1(LED_RED);

Ticker run;
void runled()
{
    led1 =! led1;
}

time_t splitDate(const char *date, const char *time)
{
    struct tm now;
    
    char s_month[5];
    int month, day, year, hour, min, sec;
    static const char month_names[] = "JanFebMarAprMayJunJulAugSepOctNovDec";

    sscanf(date, "%s %d %d", s_month, &day, &year);
    sscanf(time, "%d:%d:%d", &hour, &min, &sec);

    month = (strstr(month_names, s_month)-month_names)/3;
    
    now.tm_sec = sec;
    now.tm_min = min;
    now.tm_hour = hour + 7;
    now.tm_mon = month;
    now.tm_mday = day;
    now.tm_year = year - 1900;

    return mktime(&now);
}

int main()
{
    run.attach(&runled, 0.5f);
    dbg.baud(9600);
    dbg.printf("<Program Start>\r\n");
    
    ulang:
    if(rtc.IsConnected()){
        dbg.printf("PCF85263AT is not detected\r\n");
        dbg.printf("Reconnecting...");
        goto ulang;
    }
    dbg.printf("PCF85263AT is detected\r\n");
    
    time_t new_t = splitDate(__DATE__, __TIME__);
    rtc.set_time(new_t);

    while (true) {
        time_t t = rtc.now();
        char buffer[32];
        strftime(buffer, 32, "%d/%m/%Y %H:%M:%S \r\n", localtime(&t));
        dbg.printf("%s", buffer);
        wait(1);
    }
}
