#include "RtuRpc.h"
#include "mbed.h"
#include <sstream>

extern Serial dbg;

RtuRpc::RtuRpc(std::string host)
{
    hostAddr = host;    
}
    
void RtuRpc::commitReading(const std::time_t &dt, int readingId, double value)
{
    HTTPText dat;
    
    std::tm * ptm = std::localtime(&dt);
    char buffer[48];
    std::strftime(buffer, 48, "%Y-%m-%d-%H:%M:%S", ptm);  
    
    char sent[50];
    sprintf(sent,"%s/commitReading.php?w=%s&r=%d&v=%.2f", hostAddr.c_str(), buffer, readingId, value);
    
    HTTPResult res = cl.get(sent, &dat);  
    
    if(res == HTTP_OK)
    {
        dbg.printf("HTTP_OK\r\n"); 
    }
    else
    {
        dbg.printf("Error %d\r\n", res);
    }
}

void RtuRpc::commitEvent(const std::time_t &dt, int eventId, double value)
{
    HTTPText dat;
    
    std::tm * ptm = std::localtime(&dt);
    char buffer[48];
    
    std::strftime(buffer, 48, "%Y-%m-%d-%H:%M:%S", ptm); 

    char sent[50];
    sprintf(sent,"%s/commitReading.php?w=%s&r=%d&v=%.2f", hostAddr.c_str(), buffer, eventId, value);
    
    HTTPResult res = cl.get(sent, &dat); 
    
    if(res == HTTP_OK)
    {
        dbg.printf("HTTP_OK\r\n"); 
    }
    else
    {
        dbg.printf("Error %d\r\n", res);
    }   
}
