#include "mbed.h"
#include "DataProcess.h"

extern Serial dbg;

//-----------------------------------------------------------
// FTL Message
//-----------------------------------------------------------
FtlMessage::FtlMessage()
{
}

FtlMessage::~FtlMessage()
{
}

FtlMessage::msg FtlMessage::checkMessage(const int &lastIdentifier, const int &identifier_)
{
    switch(lastIdentifier){

    case 'A':
        if(identifier_ == 'a')return FtlMessage::OK;
        else if(identifier_ == 'n') return FtlMessage::PROERROR;
        else if(identifier_ == 's') return FtlMessage::NOTANSWER;
        break;

    case 'C':
        if(identifier_ == 'c')return FtlMessage::OK;
        else if(identifier_ == 'n') return FtlMessage::PROERROR;
        else if(identifier_ == 's') return FtlMessage::NOTANSWER;
        break;

    case 'E':
    case 'I':
        if(identifier_ == 'e')return FtlMessage::OK;
        else if(identifier_ == 'i')return FtlMessage::OK;
        else if(identifier_ == 'v')return FtlMessage::OK;
        else if(identifier_ == 'n') return FtlMessage::PROERROR;
        else if(identifier_ == 's') return FtlMessage::NOTANSWER;
        break;

    case 'R':
    case 'V':
        if(identifier_ == 'r')return FtlMessage::OK;
        else if(identifier_ == 'v')return FtlMessage::OK;
        else if(identifier_ == 'n') return FtlMessage::PROERROR;
        else if(identifier_ == 's') return FtlMessage::NOTANSWER;
        break;

    default : return FtlMessage::FAILED;
    }
    return FtlMessage::FAILED;
}

//-----------------------------------------------------------
// Data Message
//-----------------------------------------------------------
DataMessage::DataMessage()
{
}

DataMessage::~DataMessage()
{
}

DataMessage::msg DataMessage::processFromSlave(int identifier_,std::string buff, _CALLBACKPTR cb, void* param)
{
    int res = 0;
    switch(identifier_){
    case 'e':
    case 'i':
    case 'v':
        res = cb(buff.c_str(), buff.length(), param);
        break;
    }
    if(res) return DataMessage::OK;
    else return DataMessage::FAILED;
}

int DataMessage::_cbstate(const char* buf, int len, MeterState* param)
{
  if (param)
  {
    if(sscanf(buf, "%*[^= ]=%*d,%*[^, ],%*[^, ],%d", param->state) ==1)
    {
      return 1;
    }
  }
  return 0;
}

DataMessage::msg DataMessage::checkStateMessage(const int &identifier_, const std::string &stream, int *pStep)
{
    MeterState mystate;
    mystate.state = pStep;
    if(processFromSlave(identifier_, stream, _cbstate, &mystate) == DataMessage::OK)
    {
        dbg.printf("SUKSES BRO\r\n");
        return DataMessage::OK;
    }
    else
    {
        dbg.printf("GAGAL BRO\r\n");
        return DataMessage::FAILED;
    }
}

int DataMessage::_cbOstate(const char* buf, int len, OrderState* param)
{
  if (param)
  {
    if(sscanf(buf, "%*[^= ]=%d", param->state) ==1)
    {
      return 1;
    }
  }
  return 0;
}

DataMessage::msg DataMessage::checkOrderState(const int &identifier_, const std::string &stream, int *pStep)
{
    OrderState mystate;
    mystate.state = pStep;
    if(processFromSlave(identifier_, stream, _cbOstate, &mystate) == DataMessage::OK)
    {
        dbg.printf("SUKSES BRO\r\n");
        return DataMessage::OK;
    }
    else
    {
        dbg.printf("GAGAL BRO\r\n");
        return DataMessage::FAILED;
    }
}

int DataMessage::_cbInterlock(const char* buf, int len, InterlockState* param)
{
  if (param)
  {
    if(sscanf(buf, "%*[^= ]=%*d,%*d,%d,%*s", param->state) ==1)
    {
      return 1;
    }
  }
  return 0;
}

DataMessage::msg DataMessage::checkInterlock(const int &identifier_, const std::string &stream, int *pStep)
{
    InterlockState mystate;
    mystate.state = pStep;
    if(processFromSlave(identifier_, stream, _cbInterlock, &mystate) == DataMessage::OK)
    {
        dbg.printf("SUKSES BRO\r\n");
        return DataMessage::OK;
    }
    else
    {
        dbg.printf("GAGAL BRO\r\n");
        return DataMessage::FAILED;
    }
}

//-----------------------------------------------------------
DataProcess::DataProcess()
{
    stateTmp = 0;
    lastState = 0;
    OrderStateTmp = 0;
    LastOrderState = 0;
    InterlockState = 0;
}

DataProcess::~DataProcess()
{
}

void DataProcess::CheckFtlMassage(const int &lastIdentifier, const AruFrm &frm)
{
    FtlMsg = FtlMessage::checkMessage(lastIdentifier, frm.Identifier);
    return;
}

FtlMessage::msg DataProcess::getFtlMessage()
{
    return FtlMsg;
}

DataProcess::state_ DataProcess::checkState()
{
    DataProcess::state_ ret;
//    int res = stateTmp - lastState;
    
    switch(lastState)
    {
        case 0:
            if(stateTmp == 0)ret = DataProcess::STAYNOL;
            else if(stateTmp == 1)ret = DataProcess::STEPUP;
            else if(stateTmp == 2)ret = DataProcess::STEPJUMP;
            else if(stateTmp == 3)ret = DataProcess::STEPJUMP;
            else if(stateTmp == 4)ret = DataProcess::STEPEND;
            else if(stateTmp == 5)ret = DataProcess::FINISH;
            break;
        case 1:
            if(stateTmp == 0)ret = DataProcess::STEPDOWN;
            else if(stateTmp == 1)ret = DataProcess::STAY;
            else if(stateTmp == 2)ret = DataProcess::STEPUP;
            else if(stateTmp == 3)ret = DataProcess::STEPJUMP;
            else if(stateTmp == 4)ret = DataProcess::STEPEND;
            else if(stateTmp == 5)ret = DataProcess::FINISH;
            break;
        case 2:
            if(stateTmp == 0)ret = DataProcess::STEPEND;
            else if(stateTmp == 1)ret = DataProcess::STEPDOWN;
            else if(stateTmp == 2)ret = DataProcess::STAY;
            else if(stateTmp == 3)ret = DataProcess::STEPUP;
            else if(stateTmp == 4)ret = DataProcess::STEPEND;
            else if(stateTmp == 5)ret = DataProcess::ERROR;
            break;
         case 3:
            if(stateTmp == 0)ret = DataProcess::STEPEND;
            else if(stateTmp == 1)ret = DataProcess::ERROR;
            else if(stateTmp == 2)ret = DataProcess::STEPDOWN;
            else if(stateTmp == 3)ret = DataProcess::STAY;
            else if(stateTmp == 4)ret = DataProcess::STEPEND;
            else if(stateTmp == 5)ret = DataProcess::ERROR;
            break;
        case 4:
            if(stateTmp == 0)ret = DataProcess::STEPEND;
            else if(stateTmp == 1)ret = DataProcess::ERROR;
            else if(stateTmp == 2)ret = DataProcess::STEPDOWN;
            else if(stateTmp == 3)ret = DataProcess::STEPDOWN;
            else if(stateTmp == 4)ret = DataProcess::STAY;
            else if(stateTmp == 5)ret = DataProcess::FINISH;
            break;
        case 5:
            if(stateTmp == 0)ret = DataProcess::STEPEND;
            else if(stateTmp == 1)ret = DataProcess::ERROR;
            else if(stateTmp == 2)ret = DataProcess::ERROR;
            else if(stateTmp == 3)ret = DataProcess::ERROR;
            else if(stateTmp == 4)ret = DataProcess::STEPEND;
            else if(stateTmp == 5)ret = DataProcess::FINISH;
            break;
        default : ret = DataProcess::ERROR; break;
    }
    
    lastState = stateTmp;
    return ret;
}

DataProcess::state_ DataProcess::checkOrderState()
{
    DataProcess::state_ ret;
    switch(OrderStateTmp)
    {
        case 0:
            ret = DataProcess::NOORDER;
            break;
            
        case 2:
            ret = DataProcess::ORDERRCV;
            break;
            
        case 3:
            ret = DataProcess::PLANORDERPROC;
            break;
            
        case 4:
            ret = DataProcess::UNPLANORDERPROC;
            break;
            
        case 9:
            ret = DataProcess::ORDERFINERROR;
            break;
            
        case 10:
            ret = DataProcess::ORDERFINNOERROR;
            break;
    }
    
    return ret;
}

DataProcess::state_ DataProcess::chackInterlock()
{
    DataProcess::state_ ret;
    if(InterlockState == 1)
    {
        ret = DataProcess::ACCCLOSED;
    }
    else if (InterlockState == 2)
    {
        ret = DataProcess::ACCOPEN;
    }
    else
    {
        ret = DataProcess::ERROR;
    }
    
    return ret;
}

void DataProcess::CheckDtMassage(const AruFrm &frm)
{
    std::string input(frm.Data.begin(), frm.Data.end());

    switch(frm.Identifier){
    case 'e':
    case 'i':
    case 'v':
        {
            if(strstr(input.c_str(), "Meter_State"))
            { 
                DataMsg = DataMessage::checkStateMessage(frm.Identifier,  input, &stateTmp);
            }
            else if(strstr(input.c_str(), "ORDER,State"))
            {
                DataMsg = DataMessage::checkOrderState(frm.Identifier,  input, &OrderStateTmp);
            }
            else if(strstr(input.c_str(), "Interlock"))
            {
                DataMsg = DataMessage::checkInterlock(frm.Identifier,  input, &InterlockState);
            }
            else if(strstr(input.c_str(), "Meter_Info"))
            {
                DataMsg = DataMessage::OK;
            }
            else
            {
                DataMsg = DataMessage::FAILED;
            }
        }
        break;
    }

    return;
}

DataMessage::msg DataProcess::getDtMessage()
{
    return DataMsg;
}

//-----------------------------------------------------------
