#include "mbed.h"
#include "CommChannel.h"

extern Serial dbg;

//-----------------------------------------------------------------
extern std::vector<int> RCV_BUFF;   // temporary buffer receiving progress
std::vector<int> RCVD;       // buffer completed receiving
extern int timerRxTOutCnt;

//-----------------------------------------------------------------
// Mechanism for receive timeout
//
extern int timerRxTOutCnt;

//-----------------------------------------------------------------
//  Serial definition
//
extern Serial sock;

//-----------------------------------------------------------------
//  Wrapper class
//
CommChannel::CommChannel()
{
    dbg.printf("<CommChannel>");
}

CommChannel::~CommChannel()
{

}

void CommChannel::connect(const std::string &host)
{
}

int CommChannel::dataAvailable()
{
    return RCVD.size();
}

std::vector<int> CommChannel::read()
{
    std::vector<int> result;

    for(int i=0; i<RCVD.size(); i++)
        result.push_back(RCVD[i]);

    RCVD.clear();
    return result;
}

void CommChannel::write(const std::vector<int> &s)
{
    for(int i=0; i<(int)s.size(); i++)
    {
        sock.putc(s[i] & 0x0FF);
    }
}

void CommChannel::Tick10ms()
{
    timerRxTOutCnt++;
    if(timerRxTOutCnt >= 10)
    {
        timerRxTOutCnt = 0;
        
        if(RCV_BUFF.size() > 0)
        {
            for(int i=0; i<RCV_BUFF.size(); i++)
            {
                RCVD.push_back(RCV_BUFF[i]);
                dbg.printf("[%02X]", RCV_BUFF[i] & 0x0FF);
            }
            RCV_BUFF.clear();
        }
    }    
}

//-----------------------------------------------------------------
