#ifndef ARUFRAMING_H
#define ARUFRAMING_H

#include <vector>
#include <queue>
#include <string>

//------------------------------------------------------------------------------
class AruFrm;

//-----------------------------------------------------
class AruFraming
{
public:
    AruFraming();
    ~AruFraming();

    void ProcessFromAru(const std::vector<int> &stream);

    static std::vector<int> CreateFrame(const AruFrm &f);

    std::queue<AruFrm> RCV_QUE;
private:
    static unsigned int auchCRCHi[];
    static unsigned int auchCRCLo[];

    static unsigned int CRC16(const std::vector<int> &puchMsg);
};

//-----------------------------------------------------
class AruFrm
{
public:
    int Identifier;
    std::vector<int> Data;
};

//-----------------------------------------------------
class Ack : public AruFrm
{
public:
    Ack(int Identifier_)
    {
        Identifier = Identifier_;
        Data.clear();
    }
};

//-----------------------------------------------------
class Can : public AruFrm
{
public:
    Can(int Identifier_)
    {
        Identifier = Identifier_;
        Data.clear();
    }
};

//-----------------------------------------------------
class Tef : public AruFrm
{
public:
    Tef(int Identifier_)
    {
        Identifier = Identifier_;
        Data.clear();
    }
};

//-----------------------------------------------------
class Eot : public AruFrm
{
public:
    Eot(int Identifier_, std::string &data)
    {
        Identifier = Identifier_;
        std::copy(data.begin(), data.end(), back_inserter(Data));
    }
};

//-----------------------------------------------------
class Eor : public AruFrm
{
public:
    Eor(int Identifier_, std::string &data)
    {
        Identifier = Identifier_;
        std::copy(data.begin(), data.end(), Data.begin());
    }
};

//-----------------------------------------------------
#endif // ARUFRAMING_H
