#include "mbed.h"
#include "AruChannel.h"

extern Serial dbg;

AruChannel::AruChannel()
{
    dbg.printf("<AruChannel>");
    
    COM.connect("127.0.0.1:123");
    commId = 0;
}

AruChannel::~AruChannel()
{

}

int AruChannel::ReceiveCount()
{
    return Frm.RCV_QUE.size();
}

AruFrm AruChannel::Receive()
{
    AruFrm res = Frm.RCV_QUE.front();
    Frm.RCV_QUE.pop();
    return res;
}

void AruChannel::Transmit(const AruFrm &f)
{
    XMT_QUE.push(f);
}

void AruChannel::Process()
{
    if(COM.dataAvailable() > 0)
    {
        std::vector<int> r = COM.read();

        Frm.ProcessFromAru(r);
    }

    while(XMT_QUE.size() > 0)
    {
        AruFrm t = XMT_QUE.front();
        XMT_QUE.pop();

        // TCP/IP
        std::vector<int> x = AruFraming::CreateFrame(t);
        COM.write(x);

        commId++;
    }
}

void AruChannel::Tick10ms()
{
    COM.Tick10ms();    
}
