#ifndef DATAPROCESS_H
#define DATAPROCESS_H

#include <vector>
#include <queue>
#include <string>
#include "AruFraming.h"

class FtlMessage
{
public:
    FtlMessage();
    ~FtlMessage();

    enum msg
    {
        OK = 0,
        FAILED = -1,
        PROERROR = -2,
        NOTANSWER = -3
    }ftl_msg;

    msg checkMessage(const int &lastIdentifier, const int &identifier_);

private:

};

//-------------------------------------------------------------
class DataMessage
{
public:
    DataMessage();
    ~DataMessage();

    enum msg
    {
        OK = 0,
        FAILED = -1,
        CHANGE = 1,

        STATECHANGE = 2,

    }data_msg;

    typedef int (*_CALLBACKPTR)(const char* buf, int len, void* param);
    msg processFromSlave(int identifier_=0, std::string buf="", _CALLBACKPTR cb = NULL, void* param = NULL);

    template<class T>
    inline msg processFromSlave(int identifier_, std::string buf, int (*cb)(const char* buf, int len, T* param),
                  T* param)
    {
      return processFromSlave(identifier_, buf, (_CALLBACKPTR)cb, (void*)param);
    }

    msg checkStateMessage(const int &identifier_, const std::string &stream, int *pStep);
    msg checkOrderState(const int &identifier_, const std::string &stream, int *pStep);
    msg checkInterlock(const int &identifier_, const std::string &stream, int *pStep);
//private:

protected:

    typedef struct{ int *state;} MeterState;
    static int _cbstate(const char* buf, int len, MeterState* param);
    
    typedef struct{ int *state;} OrderState;
    static int _cbOstate(const char* buf, int len, OrderState* param);
    
    typedef struct{int *state;} InterlockState;
    static int _cbInterlock(const char* buf, int len, InterlockState* param);
};

//-------------------------------------------------------------
class DataProcess : public FtlMessage, public DataMessage
{
public:
    DataProcess();
    ~DataProcess();

    typedef enum state_
    {
        OK = 0,
        ERROR = -1,

        STAY = 0,
        STEPUP = 1,
        STEPDOWN = 2,
        STEPJUMP = 3,
        STEPEND = -1,
        STAYNOL = -2,
        FINISH = 4,
        
        NOORDER = 0,
        ORDERRCV = 2,
        PLANORDERPROC = 3,
        UNPLANORDERPROC = 4,
        ORDERFINERROR = 9,
        ORDERFINNOERROR = 10,
        
        ACCCLOSED = 0,
        ACCOPEN = 1
    }STATE;

    void CheckFtlMassage(const int &lastIdentifier, const AruFrm &frm);
    FtlMessage::msg getFtlMessage();

    void CheckDtMassage(const AruFrm &frm);
    DataMessage::msg getDtMessage();
    state_ checkState();
    state_ checkOrderState();
    state_ chackInterlock();

private:
    FtlMessage::msg FtlMsg;

    DataMessage::msg DataMsg;
    int stateTmp;
    int lastState;
    int OrderStateTmp;
    int LastOrderState;
    int InterlockState;
};

//-------------------------------------------------------------
#endif // DATAPROCESS_H
