#include "MDM.h"
#include "mbed.h"
#include "Modem.h"
#include <sstream>

extern Serial dbg;

void SetModem(MDMSerial &mdm)
{
    MDMParser::DevStatus devStatus = {};
    MDMParser::NetStatus netStatus = {};
    bool mdmOk = mdm.init(SIMPIN, &devStatus);
    mdm.dumpDevStatus(&devStatus);
    if (mdmOk) {
        mdmOk = mdm.registerNet(&netStatus);
        mdm.dumpNetStatus(&netStatus);
    }
    if (mdmOk)
    {   
        MDMParser::IP ip = mdm.join(APN,USERNAME,PASSWORD);
        if (ip != NOIP)
        {   
            mdm.dumpIp(ip);
            dbg.printf("\r\n<Modem Connected>");
        }
    }
}

std::string Convertint(int data)
{
    std::stringstream c;
    c << data;
    
    return c.str();
}
    
std::string Convert(double data)
{
    std::stringstream c;
    c << data;
    
    return c.str();
}

bool PostData(MDMSerial &mdm, const int &identifier_, const std::vector<int> &input, bool mode)
{
    char buf[512] = "";
    int ret;
    bool res = false;
    int socket = mdm.socketSocket(MDMParser::IPPROTO_TCP);
    
    std::string body;
    body += "{\"val\":\"";
    body += identifier_;
    body += std::string(input.begin(), input.end());
    body += "\"}";
    
    std::string http;
    if(mode == SKADA)
    {
        http += "PUT /todo/api/v1.0/scadas/1 HTTP/1.1\r\n";
    }
    else if(mode == TASK)
    {
        http += "POST /todo/api/v1.0/tasks HTTP/1.1\r\n";
    }
    http += "Host: 182.23.67.168:5000\r\n";
    http += "Authorization: Basic am9objpoZWxsbw==\r\n";
    http += "Connection: close\r\n";
    http += "Content-Type: application/json\r\n";
    http += "Content-Length: ";
    http += Convertint((int)body.size());
    http += "\r\n\r\n";
    http += body;
    http += "\r\n\r\n";
    
    dbg.printf("Request:\r\n%s",http.c_str());
    
    dbg.printf("Ready to post\r\n");
    mdm.socketSetBlocking(socket, 10000);
    if (mdm.socketConnect(socket, "182.23.67.168", 5000))
    {
        dbg.printf("Sending request\r\n");
        mdm.socketSend(socket, http.c_str(), http.size());
        
        ret = mdm.socketRecv(socket, buf, sizeof(buf)-1);
        if (ret > 0)
        {
            dbg.printf("Socket Recv \"%*s\"\r\n", ret, buf);
            if(strstr(buf, "HTTP/1.0 200") || strstr(buf, "HTTP/1.0 201"))
            {
                res = true;
            }
            else
            {
                res = false;
            }
        }
        else
        {
            dbg.printf("return 0\r\n");
            res = false;
        }
            
        mdm.socketClose(socket);
        mdm.socketFree(socket);       
    }
    else
    {
        mdm.socketSetBlocking(socket, 10000);
        mdm.socketConnect(socket, "182.23.67.168", 5000);
        res = false;
    }
    return res;
}

bool chekConect(MDMSerial &mdm)
{
    bool stat = mdm.CheckCon();
    if(!stat)
    {
        MDMParser::IP ip = mdm.join(APN,USERNAME,PASSWORD);
        if (ip != NOIP)
        {   
            mdm.dumpIp(ip);
            return true;
        }
        else
        {
            mdm.join(APN,USERNAME,PASSWORD);
            return false;
        }
    }
    else
        return true;
}
