#include "Mousr.h"

//Mousr::Mousr() : m1a(p24), m1b(p23), m2a(p22), m2b(p21)
Mousr::Mousr() : mstby(p6), m_a1(p24), m_a2(p25), mpwma(p26), m_b1(p23), m_b2(p22), mpwmb(p21)
{           
    rotateSlowSpeed   = 0.05;
    rotateSpeed       = 0.1;
    rotateFastSpeed   = 0.2;
    
    // Parameters for Flip
    flip90Wait = 0.1;
    flip180Wait = 0.2;
    mpwma = 1;
    mpwmb = 1;
    mstby = 1;
}

void Mousr::stop()
{
    m_a1 = 0; m_a2 = 0; m_b1 = 0; m_b2 = 0; return;
}

void Mousr::righttire(float speed)
{
    if (speed > 0)
    {
        m_a1 = speed; m_a2 = 0; return;
    }
    else if (speed == 0)
    {
        m_a1 = 0; m_a2 = 0; return;
    }
    else
    {
        m_a1 = 0; m_a2 = abs(speed); return;
    }   
}

void Mousr::lefttire(float speed)
{
    if (speed > 0)
    {
        m_b1 = speed; m_b2 = 0; return;
    }
    else if (speed == 0)
    {
        m_b1 = 0; m_b2 = 0; return;
    }
    else
    {
        m_b1 = 0; m_b2 = abs(speed); return;
    }  
}

void Mousr::left(float speed)
{
   m_a1 = speed; m_a2 = 0; m_b1 = 0; m_b2 = speed; return;
}

void Mousr::right(float speed)
{
   m_a1 = 0; m_a2 = speed; m_b1 = speed; m_b2 = 0; return;
}

void Mousr::left90()
{
    left(rotateFastSpeed);
    wait(flip90Wait);
    stop();
    return;
}

void Mousr::left180()
{
    left(rotateFastSpeed);
    wait(flip180Wait);
    stop();
    return;
}

void Mousr::right90()
{
    right(rotateFastSpeed);
    wait(flip90Wait);
    stop();
    return;
}

void Mousr::right180()
{
    right(rotateFastSpeed);
    wait(flip180Wait);
    stop();
    return;
}