#include "WirelessMousr.h"

WirelessMousr::WirelessMousr() : Mousr(), pc(p28, p27) {} //USE FOR BT
//WirelessMousr::WirelessMousr() : Mousr(), pc(USBTX, USBRX) {} //USE FOR USB

int WirelessMousr::init()
{
    pc.attach(this,&WirelessMousr::rxCallback);
    wait(0.1);
    return 0;
}

void WirelessMousr::rxCallback()
{
    char message = this->pc.getc(); // read RX character, clearing interrupt
    static char oldstate;
    char newstate;
    float pwmval;
    int numerator;
    float denominator;
    this->pc.putc(message);
    //this->pc.putc('\n');
    //this->pc.putc('\r');
    newstate = message;
    
        
        if ((oldstate == 'L') || (oldstate == 'R'))
        {
            //this->pc.putc('V');
            
            numerator = ((int)message - 50);
            denominator =  (float) 50;
            pwmval = ((float) numerator) / denominator;
            //pc.printf("%f \n \r",pwmval);
            //pc.printf("%d",message);
            
            if (oldstate == 'L')
            {         
                 this->lefttire(pwmval);
                 //this->pc.putc('L');
                 //this->pc.putc('L');
            }
            else if (oldstate == 'R')
            {
                this->righttire(pwmval);
                //this->pc.putc('R');
                //this->pc.putc('R');
            }
        }
        else
        {
                switch(message)
                {
                case 'q':   //STOP
                    this->left90(); 
                    /*this->pc.putc('L');
                    this->pc.putc('9');
                    this->pc.putc('0');
                    this->pc.putc('\n');*/
                    break;
                case 'a':   //STRAIGHT
                    this->left180(); 
                  /*  this->pc.putc('L');
                    this->pc.putc('8');
                    this->pc.putc('0');
                    this->pc.putc('\n');*/
                    break;
                case 'e':   //STRAIGHT SLOW
                    this->right90(); 
                 /*   this->pc.putc('R');
                    this->pc.putc('9');
                    this->pc.putc('0');
                    this->pc.putc('\n');*/
                    break;
                case 'd':   //ROTATE LEFT MEDIUM
                    this->right180(); 
             /*       this->pc.putc('R');
                    this->pc.putc('8');
                    this->pc.putc('0');
                    this->pc.putc('\n');*/
                    break;
                case 's':   //ROTATE RIGHT MEDIUM
                  this->stop();
               /*     this->pc.putc('S');
                    this->pc.putc('T');
                    this->pc.putc('P');
                    this->pc.putc('\n'); break;*/
                }
        }
    oldstate = newstate;    
}
