#include "mbed.h"
#include "SI1143.h"
#include "m3pi.h"
#define NN 1000

//DigitalOut enable(p30);
//Ticker timer;

I2C* i2c = new I2C(p28, p27);
Serial bt(p13, p14);
m3pi pi;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

InterruptIn event(p26);

SI1143 sensor1(i2c, p30, p29, 0x01);
//SI1143 sensor2(i2c, p25, p26, 0x02); // p25, p26

//InterruptIn prox_meas(p26); //26
int sense1a, sense1b, sense2a, sense2b;
int sensor1alog[NN];
int sensor1blog[NN];
int whileflag = 1;
int countingstuffpoop = 0;

void meas_int()
{
    led1 = 1;
    sense1a = sensor1.read_ps1();
    sense1b = sensor1.read_ps2();
    //sense2a = sensor2.get_ps1(1);
    //sense2b = sensor2.get_ps2(1);

    countingstuffpoop++;
    if(countingstuffpoop < NN)
    {
        led4 = 0;
        sensor1alog[countingstuffpoop-1] = sense1a;
        sensor1blog[countingstuffpoop-1] = sense1b;
    }
    else
    {
        __disable_irq(); 
        whileflag = 0;
        led4 = 1;
    }

    sensor1.clear_int();
    led1 = 0;
}

void blinkblink(int t, int n)
{
    for (int i = 1; i <= n; i++)
    {
    led4 = 1;
    wait(t);
    led4 = 0;
    wait(t);    
    }
}

int main()
{
    led2 = 0;
    //wait(10);
    blinkblink(1,2);

    event.fall(&meas_int);
    //timer.attach(&meas_int, 0.01);
    sensor1.start_ps_auto();
    led4 = 1;
    //pi.left(0.1);

    while(whileflag)
    {
        // Read each led sensor
        led2 = whileflag;
    }
    led3 = 0;
    //pi.stop();
    blinkblink(1,5);
    

    bt.printf("d = [");
    for (int i = 0; i < NN; i++)
    {
        bt.printf("%d,  %d;\r\n", sensor1alog[i], sensor1blog[i]);
        //bt.printf("%d;\r\n", sensorlog[i]);
    }
    bt.printf("0, 0];");
    led1 = 1;
    wait(0.3);
    led1 = 0;
    wait(0.3);
    led1 = 1;
}