#include "mbed.h"
#include "rtos.h"
#include <vector>
#define SIG_RX_CAN  0x01

using namespace std;

DigitalOut led1(LED1);
DigitalOut led2(LED2);

Thread threadA;
Thread threadB;
Thread threadC;
 
char * BDD[8];
 
CAN CanPort(p30, p29);
CANMessage  MessageRx; 
CANMessage  MessageTx;

CANMessage MessageBuzzer;

bool send_Buzz=false; // Envoyer trame au buzzer
bool result = false;

unsigned int    Id;

bool rechercheID(char * ID) // recherche d'un ID dans la base de données
{
    bool retour = false;
   for( int i= 0; i< sizeof(BDD); i++)
    {
        if (BDD[i]==ID) retour= true ;
    }
 return retour;
}

void canReader(void)
{
    
      
    if (CanPort.read(MessageRx))
    {
            led1 = !led1;
            switch(MessageRx.id){
                case 0x111 : 
                        threadA.signal_set(SIG_RX_CAN);
                    break;
                    
                case 0x222 :
                        threadC.signal_set(SIG_RX_CAN);
                    break;
                    
                
                default: 
                        printf("Id error = %X\n\r",MessageRx.id)  ;
                }
            
    }
    
} 
 
 void traitRFID() 
{
    int i=0;
    char* ID;
    while(true)
    {
        Thread::signal_wait(SIG_RX_CAN);    
        led2 = !led2;
        for(i=0; i<8;i++){
        printf("Numero de carte = %X\n\r",MessageRx.data[i]);
        ID[i]= MessageRx.data[i];
        }  
        result= rechercheID(ID);
        send_Buzz=true;
      
        //si buzz ok, on traite Buzz par un signal
        
    }
}

void thA() 
{
    int i=0;
    while(true)
    {
        Thread::signal_wait(SIG_RX_CAN);    
        led2 = !led2;
        if(MessageRx.data[0]==0x01){
            printf("RX ID = %X \t\n\r",MessageRx.id);
            for (i=0;i<8;i++){
                 printf(" DATA = %X \n\r",MessageRx.data[i]);
            }
        }
    }
}
 
void traitBuzz() 
{
    while(true) 
    {
    led1 = !led1;   
    printf("TIC3s\n\r");

    Id = 0x222;
    MessageBuzzer.len=1;
  
    MessageBuzzer.id=Id;
        if( send_Buzz==true)
        {
             if (result)     MessageBuzzer.data[0] = 0x01; 
             else     MessageBuzzer.data[0] = 0x00; 
        
              CanPort.write(MessageBuzzer);
              send_Buzz=false;
        }
          
    }
}

int main() 
{
    
    CanPort.frequency(20000);
    

    //MessageTx.data[1] = 0xAA;
    
    MessageTx.format = CANStandard;
    //MessageTx.format = CANExtended;
    
    MessageTx.type = CANData;
    //MessageTx.type = CANRemote;
    
    CanPort.attach(canReader,CAN::RxIrq);
        
    threadA.start(thA);
    threadB.start(traitBuzz);
    threadC.start(traitRFID);
    
    led1 = 0;
    led2 =0 ;
    printf("Start OK\n\r");

    

    while (true) 
        {
    
        }
}
