/*
 * Mbed Application program
 *  SD Card file control function with FatFs on Mbed-os5
 *
 * Copyright (c) 2018 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    April      7th, 2018
 *      Revised:    April     30th, 2018
 */

//  Include --------------------------------------------------------------------
#include    "mbed.h"
//#include "USBHostMSD.h"
#include    "FATFileSystem.h"
#include    "SDBlockDeviceDISCOF469NI.h"
//#include    "mon.h"
#include    <stdlib.h>
#include    <stdio.h>
#include    <errno.h>

//  Definition -----------------------------------------------------------------
#define     USER_SW_ON      1

//  Constructor ----------------------------------------------------------------
DigitalOut      led(LED1);
DigitalOut led_orange(LED2);
DigitalOut led_red(LED3);
DigitalOut led_blue(LED4);
DigitalIn       user_sw(USER_BUTTON);
Serial          uart(USBTX, USBRX);
// Instantiate the Block Device for sd card on DISCO-F469NI
SDBlockDeviceDISCOF469NI bd;
//USBHostMSD msd;
FATFileSystem   fs("fs");
Timer tic;

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------
char *const opening_msg0 = "microSD Card test program";
char *const opening_msg1 = " -> run on Mbed OS-5\r\n";

//  Function prototypes --------------------------------------------------------
void return_error (int ret_val);
void errno_error (void* ret_val);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
/*int main()
{
    time_t      seconds;
    uint32_t data0 = 10000U;

    if (user_sw == USER_SW_ON) {
   //     mon();
            uart.printf("Start BUTTON ON\r\n");
            
    }
    //pc.printf("line:%d\r\n", __LINE__);
    uart.printf("\r\nStart\r\n");
    int error = 0;
    error = fs.mount(&bd);
    return_error(error);
/*
    FILE* fp = fopen("/fs/test.txt", "w");
    errno_error(fp);
    if (fp != 0) {
        pc.printf("OPEN : %s%s",  opening_msg0, opening_msg1);
        fprintf(fp,"OPEN : %s%s", opening_msg0, opening_msg1);
    } else {
        pc.printf("ERROR\r\n");
    }
    fclose(fp);
 */
  
 //       uint32_t size = get_disk_freespace();
 //           seconds = time(NULL);
 //           strftime(tmp, 64, "DATE %H:%M:%S,%Y/%m/%d,", localtime(&seconds));
 /*   while(true) {
        mon();
        NVIC_SystemReset();
    }*/
/*    pc.printf("terminé\r\n");
    while(1);
}*/

void return_error (int ret_val)
{
    if (ret_val) {
        uart.printf("retrun error/Failure. %d\r\n", ret_val);
    }
}

void errno_error (void* ret_val)
{
    if (ret_val == NULL) {
        uart.printf("error #/Failure. %d \r\n", errno);
    }
}


unsigned int count=0,val1,val2;
char tmess[]="/fs/test1.txt";
    unsigned int  index;
#define TAILLEMAX (4096*4)
#define ITER 50000
unsigned flag;
unsigned char tabf[TAILLEMAX+1];

unsigned int tstat[20000];
unsigned int cal1,cal2;
double ff;
unsigned long vdebut,vfin;
int main(){
unsigned int max=0,min=200000000;
int retour;
led=1;
led_orange=1;
led_red=1;
led_blue=1;
 int error = 0;
    //led4=1;
    uart.printf("TEST\r\n");
    led_red=0;
     wait(0.1);
 /*   while(!msd.connect()) {
            wait(0.500);
    }*/
    led_red=1;    
    error = fs.mount(&bd);//bd);
    return_error(error);
    wait(0.1);
    FILE *fp = fopen(tmess, "w");
     errno_error(fp);
    if(fp==0){
  //      led1=1;
  //      led2=1;
 //       led4=0;
        uart.printf("erreur ouverture fichier\r\n");
        while(1);
    }
    uart.printf("DEBUT TEST\r\n");
    tic.reset();
    tic.start();
 //   tc1.attach(&per,0.001);
 vdebut=tic.read_us();
    while(count<ITER){
           // if(flag>0){
                            led=0;
               //     flag--;
                    val1= tic.read_us();
                    *((unsigned int*)tabf)=val1;
                 *((unsigned int*)(tabf+12))=0;
                    fwrite(tabf,1,TAILLEMAX,fp);
                 *((unsigned int*)(tabf+16))=0;
                  val2=tic.read_us();
                  cal1=val2-val1;
                    *((unsigned int*)(tabf+4))=val2;
                    *((unsigned int*)(tabf+8))=cal1;
                    //uart.printf("max = %u   min=%u    flag=%u\n",max,min,flag);
                    if(cal1>max){
                                max=cal1;
                    }
                    if(cal1<min){
                                min=cal1;
                    }
                    cal1 = (cal1+50)/100;
                    if(cal1>19999) cal1=19999;
                    tstat[cal1]=tstat[cal1]+1;
                    count++;
                    led=1;
                    wait(0.003);
                    //led3=0;
            //}
    } 
    vfin=tic.read_us();      
    fclose(fp);
    fp=fopen("/fs/fin.txt","w");
    if(fp==0){
  //      led1=1;
  //      led2=1;
 //       led4=0;
          uart.printf("erreur ouverture fichier STAT\r\n");
          while(1);
    }
    for(cal2=0;cal2<20000;cal2++){
            if(tstat[cal2]!=0){
                    ff=ff+ (cal2/10.)*(tstat[cal2]/(double)ITER);
                    fprintf(fp,"%u\t%u\r\n",cal2,tstat[cal2]);
            }
    }
   
   
    fprintf(fp,"max = %u   min=%u    moyenne=%u   tempstotal(ms)=%u\r\n",max,min,(unsigned)(ff*1000),(vfin-vdebut)/1000);
    fclose(fp);
   // led4=1; 
    uart.printf("max = %u   min=%u    moyenne=%u   tempsmanip(H)=%f\r\n",max,min,(unsigned)(ff*1000),(((vfin-vdebut)/1000000.)+1)/3600.);
    while(1);
}