#include "mbed.h"
#include "EthernetInterface.h"
#include "LM75B.h"

static const char* mbedIP = "192.168.5.10";  //IP 
static const char* mbedMask = "255.255.255.0";  // Mask
static const char* mbedGateway = "192.168.5.1";    //Gateway

const int ECHO_SERVER_PORT = 2224;
const char* ECHO_SERVER_ADDRESS = "192.168.5.15";    // laptop address

LM75B sensor(p28,p27);

int main() {
    EthernetInterface eth;
    eth.init(mbedIP,mbedMask,mbedGateway); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    
    while(1) {
        if (sensor.open()) {
            printf("Device detected!\n");

            while (1) {
                cls();
                locate(0,3);
                printf("Temp = %.3f\n", (float)sensor);
                wait(1.0);
            TCPSocketConnection sock;
            sock.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
            char http_cmd[] = "Testing";
            sock.send_all(http_cmd, sizeof(http_cmd)-1);
        
            char buffer[300];
            int ret;
            while (false) {
                ret = sock.receive(buffer, sizeof(buffer)-1);
                if (ret <= 0)
                    break;
                buffer[ret] = '\0';
                printf("Temp = %.3f\n", (float)sensor);
                printf("Received %d chars from server:\n%s\n", ret, buffer);
            }
              
            sock.close();
            Thread::wait(1000);
      
        }

    } else {
        error("Device not detected!\n");
    }
    }
    
    eth.disconnect();
    
    
}
