/*******************************************************************************
 * This file is part of the NewTicker library.                                 *
 *                                                                             *
 * NewTicker is free software: you can redistribute it and/or                  *
 * modify it under the terms of the GNU General Public License as              *
 * published by the Free Software Foundation, either version 3 of              *
 * the License, or any later version.                                          *
 *                                                                             *
 * NewTicker is distributed in the hope that it will be useful,                *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 * GNU Lesser General Public License for more details.                         *
 *                                                                             *
 * NewTicker is distributed in the hope that it will be useful,                *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 * GNU Lesser General Public License for more details.                         *
 *                                                                             *
 * You should have received a copy of the GNU Lesser General Public            *
 * License along with NewTicker. If not, see                                   *
 * <http://www.gnu.org/licenses/>.                                             *
 ******************************************************************************/

/*
 *  Copyright:  DFRobot
 *  name:       NewTicker
 *  version:    1.0
 *  Author:     lisper (lisper.li@dfrobot.com)
 *  Date:       2014-10-30
 *  Description:    new ticker library for mbed
 */

#include "mbed.h"
#include "millis.h"
#include "NewTicker.h"

NewTicker::NewTicker (void)
{
    //nowTime = millis ();
}

void NewTicker::attach (void (*theTickerHandler) (), uint32_t theDelayTime)
{
    tickerHandler = theTickerHandler;
    delayTime = theDelayTime;
    nowTime = millis ();
}

void NewTicker::detach ()
{
    tickerHandler = NULL;
}

void NewTicker::update ()
{
    if (tickerHandler == NULL)
        return;
    if (millis () - nowTime > delayTime) {
        nowTime = millis ();
        tickerHandler ();
    }
}

