/*Program Example 7: Tests reaction time, and demos use of Timer and Timeout functions */
#include "mbed.h"
#include <stdio.h>
#include <stdlib.h> //contains rand() function
void measure ();
Serial pc(USBTX, USBRX);
DigitalOut led1(D5);
DigitalOut led4(D6);
DigitalIn responseinput(PC_13); //the player hits the switch connected here to respond 
Timer t; //used to measure the response time
Timeout action; //the Timeout used to initiate the response speed test

int main (){
    pc.printf("Reaction Time Test\n\r"); 
    pc.printf("------------------\n\r"); 
    while (1) {
        int r_delay; //this will be the â€œrandomâ€ delay before the led is blinked 
        pc.printf("New Test\n\r");
        led4=1; //warn that test will start
        wait(0.2);
        led4=0;
        r_delay = rand() % 10 + 1; // generates a pseudorandom number range 1-10 
        pc.printf("random number is %i\n\r", r_delay); // allows test randomness;
//removed for normal play
        action.attach(&measure,r_delay); // set up Timeout to call measure()
// after random time
        wait(10); //test will start within this time, and we then return to it
    }
}


void measure () // called when the led blinks, and measures response time
{
    if (responseinput == 1) { //detect cheating! 
        pc.printf("Do not hold button down!\n");
    } else {
        t.start(); //start the timer 
        led1=1; //blink the led 
        wait(0.05);
        led1=0;
        while (responseinput==0) {
            //wait here for response
        }
        t.stop(); //stop the timer once response detected
        pc.printf("Your reaction time was %f seconds\n\r", t.read());
        t.reset();
    }
}