/* Program Example 1: Declaration of objects and functions in LCD.cpp file 2. */ 
#include "LCD.h" 
DigitalOut RS(D12); 
DigitalOut E(D11);
BusOut data(D5, D4, D3, D2);
    void toggle_enable(void)
    { 
        E=1;
        wait(0.001);
        E=0; 
        wait(0.001);
    } 

    void LCD_init(void) { 
        wait(0.02); // pause for 20 ms 
        RS=0; // set low to write control data 
        E=0; // set low 20. //function mode 21. 
        data=0x2; // 4 bit mode (data packet 1, DB4-DB7) 22. 
        toggle_enable();  
        data=0x8; // 2-line, 7 dot char (data packet 2, DB0-DB3) 24. 
        toggle_enable(); //display mode 26. 
        data=0x0; // 4 bit mode (data packet 1, DB4-DB7)
        toggle_enable(); 
        data=0xF; // display on, cursor on, blink on 
        toggle_enable(); //clear display 
        data=0x0; // 
        toggle_enable(); 
        data=0x1; // clear 
        toggle_enable(); 
    } //display function 

    void display_to_LCD(char value) 
    { 
        RS=1; // set high to write character data 
        data=value>>4; // value shifted right 4 = upper nibble 
        toggle_enable(); 
        data=value; // value bitmask with 0x0F = lower nibble 
        toggle_enable(); 
     }  //locate function 
     void set_location(char location) 
     { 
        RS=0; 
        data=(location|0x80)>>4; // upper nibble 
        toggle_enable(); 
        data=location&0x0F; // lower nibble 
        toggle_enable(); 
     }