#include "mbed.h"

AnalogIn fotores_left(A0);
AnalogIn fotores_right(A1);
PwmOut PWM1(D5);
PwmOut PWM2(D6);

const float Soglia_buio=0.40;
const float Soglia_uniformita=0.120;
const float alfa=5;

void control_led(float val1, float val2);

int main (){
    PWM1.period(0.001);
    PWM2.period(0.001);
    float val1=0;
    float val2=0;
    while (1){
        val1=fotores_left.read();
        val2=fotores_right.read();
        control_led(val1,val2);
        wait(0.1);
    }
}

void control_led(float val1, float val2){
    if((val2>Soglia_buio)||(val1>Soglia_buio)){
        if(abs(val2-￼val1)<Soglia_uniformita) {    // se la luce è uniforme su entrambe le fotoresistenze
            PWM1=1;
            PWM2=1;
        }else{
            if((val1-val2)>0) {
                float a=1-(alfa*(val1-val2));
                if (a<0){
                    a=0;
                }
                PWM1=a;
                PWM2=1;
                //wait (0.1);
            }else{
                PWM1=1;
                float a=1-(alfa*(val2-val1));
                if (a<0){
                    a=0;
                }
                PWM2=a;
                //wait (0.1);
            }
        } 
    } else { 
        PWM1=0;
        PWM2=0; 
    }
}
￼￼￼￼￼￼