#ifndef _I2C_H_
#define _I2C_H_
/*
    ****************************************************************************
    ****************************************************************************
    ** DEVINT BİLİŞİM YAZILIM DONANIM TİC. LTD. ŞTİ. TARAFINDAN GELİŞTİRİLMİŞTİR
    ** İzmir / TÜRKİYE
    **
    ** (C) 2015
    ****************************************************************************
    ****************************************************************************
    *************************************************************** K A M B O ** 
*/

// FONKSIYON PROTOTİPLERİ
void eeprom_write(uint8_t eepromtype, uint16_t memory_address, uint8_t value);
//******************************************************************************

uint8_t eeprom_read(uint8_t eepromtype, uint16_t memory_address);
//******************************************************************************

bool io_send(uint8_t first_byte, uint8_t second_byte);
//******************************************************************************

//
void eeprom_write(uint8_t eepromtype, uint16_t memory_address, uint8_t val)
{
    if (eepromtype == 1) {                          // 1 bayt adresleme
    
        fnode.edata2[0] = memory_address;
        fnode.edata2[1] = val;
        i2c.write(EEPROM_ADDRESS, fnode.edata2, 2, false);
        wait_ms(10);

    } else {                                        // 2 bayt adresleme
    
        fnode.edata3[0] = memory_address >> 8;
        fnode.edata3[1] = memory_address & 0xFF;
        fnode.edata3[2] = val;
        i2c.write(EEPROM_ADDRESS, fnode.edata3, 3, false);
        wait_ms(10);
        
    }
}

//
uint8_t eeprom_read(uint8_t eepromtype, uint16_t memory_address)
{
    if (eepromtype == 1) {                          // 1 bayt adresleme
    
        fnode.edata = memory_address;
        i2c.write(EEPROM_ADDRESS, &fnode.edata, 1, true);
        wait_ms(5);
        i2c.read(EEPROM_ADDRESS, &fnode.value, 1, false);
        wait_ms(10);
        
        return (uint8_t)fnode.value;

    } else {                                        // 2 bayt adresleme
    
        fnode.edata2[0] = memory_address >> 8;
        fnode.edata2[1] = memory_address & 0xFF;
        i2c.write(EEPROM_ADDRESS, fnode.edata2, 2, true);
        wait_ms(5);
        i2c.read(EEPROM_ADDRESS, &fnode.value, 1, false);
        wait_ms(10);

        return (uint8_t)fnode.value;
        
    }
}

//
//
bool io_send(uint8_t first_byte, uint8_t second_byte)
{
    bool _success = false;

    fnode.iodata[0] = first_byte;
    fnode.iodata[1] = second_byte;

    // Try max. 3 times
    for (uint8_t i = 0; i < 3; i++) {

        if (i2c.write(IO_EXPANDER_ADDRESS, fnode.iodata, 2) == 0) {
            _success = true;
        }

        if (_success == true) {
            break;
        }
    }

    return _success;
}
#endif