#ifndef FUNCTION_H
#define FUNCTION_H

/*
    ****************************************************************************
    ****************************************************************************
    ** DEVINT BİLİŞİM YAZILIM DONANIM TİC. LTD. ŞTİ. TARAFINDAN GELİŞTİRİLMİŞTİR
    ** İzmir / TÜRKİYE
    **
    ** Copyright (C) 2015
    ****************************************************************************
    ****************************************************************************
    *************************************************************** K A M B O **
*/

// FONKSIYON PROTOTİPLERİ
void configure_eeprom_default_values(void);
//******************************************************************************

void init_node(void);
//******************************************************************************

float read_pressure_dp(void);
//******************************************************************************

float read_pressure(void);
//******************************************************************************

void prepare_data(void);
//******************************************************************************

void prepare_data_fread(void);
//******************************************************************************

void send_to_coordinator(char* char_array);
//******************************************************************************

void process_command(uint8_t cmmnd);
//******************************************************************************

void data_transmit_isr(void);
//******************************************************************************

void rf_rx_isr(void);
//******************************************************************************

void master_rx_isr(void);
//******************************************************************************

bool open_solenoid(uint8_t filter_no);
//******************************************************************************

bool close_solenoid(uint8_t filter_no);
//******************************************************************************

float map(float x, float in_min, float in_max, float out_min, float out_max);
//******************************************************************************

void watermeter_isr(void);
//******************************************************************************

void flowrate_isr(void);
//******************************************************************************

void flush_phase_isr(void);
//******************************************************************************

void pressure_check_isr(void);
//******************************************************************************

bool check_and_close_valves(void);
//******************************************************************************

void periodic_flush_isr(void);
//******************************************************************************

void min_flush_interval_isr(void);
//******************************************************************************

void rt_data_transmit_isr(void);
//******************************************************************************

void send_alarm(uint8_t _alarmID, uint16_t _filterID, uint8_t _slaveID);
//******************************************************************************

bool send_command(uint8_t _slaveid, uint8_t _command, uint8_t _filterid);
//******************************************************************************

// FONKSIYONLAR
float map(float x, float in_min, float in_max, float out_min, float out_max)
{
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

//
bool check_and_close_valves()
{
    bool check = false;

    for (uint8_t _slaveID = 0; _slaveID <= fnode.totalSlaveNumber - 1; _slaveID++) {

        for (uint8_t _filterNo = 0; _filterNo < 5; _filterNo ++) {

            if (send_command(_slaveID, CLOSE_SOLENOID, _filterNo)) {

                check = true;
                wait_ms(500);

            } else {

                check = false;

            }

            if (check == false) {
                break;
            }
        }

        if (check == false) {
            break;
        }
    }

    return check;
}

bool open_solenoid(uint8_t _filter_no)
{
    bool _success = false;

    switch (_filter_no) {

        case FILTER_1_SOLENOID: {                                            // OUT1

            // İleri
            fnode.filterByte_2 &= ~(1 << 6);                       // Bit 6 = 0
            fnode.filterByte_1 = fnode.filterByte_1;

            if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                _success = true;

                // H-köprüsünü aç ve uyandır
                fnode.filterByte_2 &= ~(1 << 5);                       // Bit 5 = 0
                fnode.filterByte_2 &= ~(1 << 4);                       // Bit 4 = 0
                fnode.filterByte_1 = fnode.filterByte_1;

                if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                    wait_ms(250);

                    _success = true;

                    // Uyut ve H-köprüsünü kapat
                    fnode.filterByte_2 |= 1 << 4;                          // Bit 4 = 1
                    fnode.filterByte_2 |= 1 << 5;                          // Bit 5 = 1
                    fnode.filterByte_1 = fnode.filterByte_1;

                    if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                        _success = true;

                    } else {

                        _success = false;

                    }

                } else {

                    _success = false;

                }

            } else {

                _success = false;

            }
        }
        break;

        case FILTER_2_SOLENOID: {                                            // OUT2

            // İleri
            fnode.filterByte_2 &= ~(1 << 3);                       // Bit 3 = 0
            fnode.filterByte_1 = fnode.filterByte_1;

            if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                _success = true;

                // H-köprüsünü aç ve uyandır
                fnode.filterByte_2 &= ~(1 << 2);                       // Bit 2 = 0
                fnode.filterByte_2 &= ~(1 << 1);                       // Bit 1 = 0
                fnode.filterByte_1 = fnode.filterByte_1;

                if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                    wait_ms(250);

                    _success = true;

                    // Uyut ve H-köprüsünü kapat
                    fnode.filterByte_2 |= 1 << 1;                          // Bit 1 is 1
                    fnode.filterByte_2 |= 1 << 2;                          // Bit 2 is 1
                    fnode.filterByte_1 = fnode.filterByte_1;

                    if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                        _success = true;

                    } else {

                        _success = false;

                    }


                } else {

                    _success = false;

                }

            } else {

                _success = false;

            }
        }
        break;

        case FILTER_3_SOLENOID: {                                            // OUT3

            // İleri
            fnode.filterByte_2 &= ~(1 << 0);                       // Bit 0 = 0
            fnode.filterByte_1 = fnode.filterByte_1;

            if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                _success = true;

                // H-köprüsünü aç ve uyandır
                fnode.filterByte_1 &= ~(1 << 7);                       // Bit 7 = 0
                fnode.filterByte_1 &= ~(1 << 6);                       // Bit 6 = 0
                fnode.filterByte_2 = fnode.filterByte_2;

                if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                    wait_ms(250);

                    _success = true;

                    // Uyut ve H-köprüsünü kapat
                    fnode.filterByte_1 |= 1 << 6;                          // Bit 6 = 1
                    fnode.filterByte_1 |= 1 << 7;                          // Bit 7 = 1
                    fnode.filterByte_2 = fnode.filterByte_2;

                    if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                        _success = true;

                    } else {

                        _success = false;

                    }

                } else {

                    _success = false;

                }

            } else {

                _success = false;

            }
        }
        break;

        case FILTER_4_SOLENOID: {                                            // OUT4

            // İleri
            fnode.filterByte_1 &= ~(1 << 5);                       // Bit 5 = 0
            fnode.filterByte_2 = fnode.filterByte_2;

            if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                _success = true;

                // H-köprüsünü aç ve uyandır
                fnode.filterByte_1 &= ~(1 << 4);                       // Bit 4 = 0
                fnode.filterByte_1 &= ~(1 << 3);                       // Bit 3 = 0
                fnode.filterByte_2 = fnode.filterByte_2;

                if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                    wait_ms(250);

                    _success = true;

                    // Uyut ve H-köprüsünü kapat
                    fnode.filterByte_1 |= 1 << 3;                          // Bit 3 = 1
                    fnode.filterByte_1 |= 1 << 4;                          // Bit 4 = 0
                    fnode.filterByte_2 = fnode.filterByte_2;

                    if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                        _success = true;

                    } else {

                        _success = false;

                    }

                } else {

                    _success = false;

                }

            } else {

                _success = false;

            }
        }
        break;

        case FILTER_MAIN_SOLENOID: {                                         // OUT5

            // İleri
            fnode.filterByte_1 &= ~(1 << 2);                       // Bit 2 = 0
            fnode.filterByte_2 = fnode.filterByte_2;

            if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                _success = true;

                // H-köprüsünü aç ve uyandır
                fnode.filterByte_1 &= ~(1 << 1);                       // Bit 1 = 0
                fnode.filterByte_1 &= ~(1 << 0);                       // Bit 0 = 0
                fnode.filterByte_2 = fnode.filterByte_2;

                if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                    wait_ms(250);

                    _success = true;

                    // Uyut ve H-köprüsünü kapat
                    fnode.filterByte_1 |= 1 << 0;                          // Bit 0 = 1
                    fnode.filterByte_1 |= 1 << 1;                          // Bit 1 = 0
                    fnode.filterByte_2 = fnode.filterByte_2;

                    if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                        _success = true;

                    } else {

                        _success = false;

                    }

                } else {

                    _success = false;

                }

            } else {

                _success = false;

            }
        }
        break;
    }

    return _success;
}

//
bool close_solenoid(uint8_t _filter_no)
{
    bool _success = false;

    switch (_filter_no) {

        case FILTER_1_SOLENOID: {                                            // OUT1

            // Geri
            fnode.filterByte_2 |= 1 << 6;                          // Bit 6 = 1
            fnode.filterByte_1 = fnode.filterByte_1;

            if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                _success = true;

                // H-köprüsünü aç ve uyandır
                fnode.filterByte_2 &= ~(1 << 5);                       // Bit 5 = 0
                fnode.filterByte_2 &= ~(1 << 4);                       // Bit 4 = 0
                fnode.filterByte_1 = fnode.filterByte_1;

                if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                    wait_ms(250);

                    _success = true;

                    // Uyut ve H-köprüsünü kapat
                    fnode.filterByte_2 |= 1 << 4;                          // Bit 4 = 1
                    fnode.filterByte_2 |= 1 << 5;                          // Bit 5 = 1
                    fnode.filterByte_1 = fnode.filterByte_1;

                    if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                        _success = true;

                    } else {

                        _success = false;

                    }

                } else {

                    _success = false;

                }


            } else {

                _success = false;

            }
        }
        break;

        case FILTER_2_SOLENOID: {                                            // OUT2

            // Geri
            fnode.filterByte_2 |= 1 << 3;                          // Bit 3 = 1
            fnode.filterByte_1 = fnode.filterByte_1;

            if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                _success = true;

                // H-köprüsünü aç ve uyandır
                fnode.filterByte_2 &= ~(1 << 2);                       // Bit 2 = 0
                fnode.filterByte_2 &= ~(1 << 1);                       // Bit 1 = 0
                fnode.filterByte_1 = fnode.filterByte_1;

                if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                    wait_ms(250);

                    _success = true;

                    // Uyut ve H-köprüsünü kapat
                    fnode.filterByte_2 |= 1 << 1;                          // Bit 1 = 1
                    fnode.filterByte_2 |= 1 << 2;                          // Bit 2 = 1
                    fnode.filterByte_1 = fnode.filterByte_1;

                    if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                        _success = true;

                    } else {

                        _success = false;

                    }

                } else {

                    _success = false;

                }

            } else {

                _success = false;

            }
        }
        break;

        case FILTER_3_SOLENOID: {                                            // OUT3

            // Geri
            fnode.filterByte_2 |= 1 << 0;                          // Bit 0 = 1
            fnode.filterByte_1 = fnode.filterByte_1;

            if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                _success = true;

                // H-köprüsünü aç ve uyandır
                fnode.filterByte_1 &= ~(1 << 7);                       // Bit 7 = 0
                fnode.filterByte_1 &= ~(1 << 6);                       // Bit 6 = 0
                fnode.filterByte_2 = fnode.filterByte_2;

                if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                    wait_ms(250);

                    _success = true;

                    // Uyut ve H-köprüsünü kapat
                    fnode.filterByte_1 |= 1 << 6;                          // Bit 6 = 1
                    fnode.filterByte_1 |= 1 << 7;                          // Bit 7 = 1
                    fnode.filterByte_2 = fnode.filterByte_2;

                    if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                        _success = true;

                    } else {

                        _success = false;

                    }

                } else {

                    _success = false;

                }

            } else {

                _success = false;

            }
        }
        break;

        case FILTER_4_SOLENOID: {                                            // OUT4

            // Geri
            fnode.filterByte_1 |= 1 << 5;                          // Bit 5 = 1
            fnode.filterByte_2 = fnode.filterByte_2;

            if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                _success = true;

                // H-köprüsünü aç ve uyandır
                fnode.filterByte_1 &= ~(1 << 4);                       // Bit 4 = 0
                fnode.filterByte_1 &= ~(1 << 3);                       // Bit 3 = 0
                fnode.filterByte_2 = fnode.filterByte_2;

                if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                    wait_ms(250);

                    _success = true;

                    // Uyut ve H-köprüsünü kapat
                    fnode.filterByte_1 |= 1 << 3;                          // Bit 3 = 1
                    fnode.filterByte_1 |= 1 << 4;                          // Bit 4 = 0
                    fnode.filterByte_2 = fnode.filterByte_2;

                    if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                        _success = true;

                    } else {

                        _success = false;

                    }

                } else {

                    _success = false;

                }

            } else {

                _success = false;

            }
        }
        break;

        case FILTER_MAIN_SOLENOID: {                                         // OUT5

            // Geri
            fnode.filterByte_1 |= 1 << 2;                          // Bit 2 = 1
            fnode.filterByte_2 = fnode.filterByte_2;

            if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                _success = true;

                // H-köprüsünü aç ve uyandır
                fnode.filterByte_1 &= ~(1 << 1);                       // Bit 1 = 0
                fnode.filterByte_1 &= ~(1 << 0);                       // Bit 0 = 0
                fnode.filterByte_2 = fnode.filterByte_2;

                if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                    wait_ms(250);

                    _success = true;

                    // Uyut ve H-köprüsünü kapat
                    fnode.filterByte_1 |= 1 << 0;                          // Bit 0 = 1
                    fnode.filterByte_1 |= 1 << 1;                          // Bit 1 = 0
                    fnode.filterByte_2 = fnode.filterByte_2;

                    if (io_send(fnode.filterByte_1, fnode.filterByte_2) == true) {

                        _success = true;

                    } else {

                        _success = false;

                    }

                } else {

                    _success = false;

                }

            } else {

                _success = false;

            }
        }
        break;
    }

    return _success;
}

//
void configure_eeprom_default_values()
{
    if (eeprom_read(EEPROM_TYPE, DEFAULT_CONFIG_ADDR) != 35) {

        for (uint8_t i = 0; i < 99; i++) {

            eeprom_write(EEPROM_TYPE, i, 0xFF);

        }

        eeprom_write(EEPROM_TYPE, DEFAULT_CONFIG_ADDR, 35);

        eeprom_write(EEPROM_TYPE, SYSTEM_SETUP_ADDR, SYSTEM_SETUP_DEFAULT);
        eeprom_write(EEPROM_TYPE, AUTOSEND_STATUS_ADDR, AUTOSEND_STATUS_DEFAULT);
        eeprom_write(EEPROM_TYPE, IRRI_TRANSMIT_INTERVAL_ADDR, IRRI_TRANSMIT_INTERVAL_DEFAULT);
        eeprom_write(EEPROM_TYPE, DRY_TRANSMIT_INTERVAL_ADDR, DRY_TRANSMIT_INTERVAL_DEFAULT);
        eeprom_write(EEPROM_TYPE, WATERMETER_COEFF_ADDR_1, WATERMETER_COEFF_DEFAULT >> 8);
        eeprom_write(EEPROM_TYPE, WATERMETER_COEFF_ADDR_2, WATERMETER_COEFF_DEFAULT & 0xFF);
        eeprom_write(EEPROM_TYPE, PMAX_ADDR, PMAX_DEFAULT);
        eeprom_write(EEPROM_TYPE, PRESSURE_SENSOR_ADDR, PRESSURE_SENSOR_DEFAULT);
        eeprom_write(EEPROM_TYPE, DP_ADDR, DP_DEFAULT);
        eeprom_write(EEPROM_TYPE, PRESSURE_CONTROL_FREQUENCY_ADDR, PRESSURE_CONTROL_FREQUENCY_DEFAULT);
        eeprom_write(EEPROM_TYPE, FLUSH_DURATION_ADDR, FLUSH_DURATION_DEFAULT);
        eeprom_write(EEPROM_TYPE, FLUSH_INTERVAL_ADDR, FLUSH_INTERVAL_DEFAULT);
        eeprom_write(EEPROM_TYPE, FLOW_CONTROL_LATENCY_ADDR, FLOW_CONTROL_LATENCY_DEFAULT);
        eeprom_write(EEPROM_TYPE, FLUSH_ENABLE_ADDR, FLUSH_ENABLE_DEFAULT);
        eeprom_write(EEPROM_TYPE, PR_SENSOR_POSITION_ADDR, PR_SENSOR_POSITION_DEFAULT);
        eeprom_write(EEPROM_TYPE, BACKFLUSH_STOP_ADDR, BACKFLUSH_STOP_DEFAULT);
        eeprom_write(EEPROM_TYPE, INLET_PRS_LOW_TRS_ADDR, INLET_PRS_LOW_TRS_DEFAULT);
        eeprom_write(EEPROM_TYPE, INLET_PRS_HIGH_TRS_ADDR, INLET_PRS_HIGH_TRS_DEFAULT);
        eeprom_write(EEPROM_TYPE, ALARMS_ENABLE_ADDR, ALARMS_ENABLE_DEFAULT);
        eeprom_write(EEPROM_TYPE, DP_HIGH_TRS_ADDR, DP_HIGH_TRS_DEFAULT);
        eeprom_write(EEPROM_TYPE, INLET_PRS_SET_ADDR, INLET_PRS_SET_DEFAULT);
        eeprom_write(EEPROM_TYPE, OUTLET_PRS_SET_FOR_DP_ADDR, OUTLET_PRS_SET_FOR_DP_DEFAULT);
        eeprom_write(EEPROM_TYPE, PERIODIC_FLUSH_ADDR, PERIODIC_FLUSH_DEFAULT);
        eeprom_write(EEPROM_TYPE, MIN_FLUSH_INTERVAL_ADDR_1, MIN_FLUSH_INTERVAL_DEFAULT >> 8);
        eeprom_write(EEPROM_TYPE, MIN_FLUSH_INTERVAL_ADDR_2, MIN_FLUSH_INTERVAL_DEFAULT & 0xFF);
        eeprom_write(EEPROM_TYPE, FILTER_NUMBER_ADDR, FILTER_NUMBER_DEFAULT);
    }
}

//
void init_node()
{
    // EEPROM'dan sistem ayarlarını oku
    fnode.systemSetup = eeprom_read(EEPROM_TYPE, SYSTEM_SETUP_ADDR);

    // Filtre sayısını hesapla
    fnode.filterNumber = eeprom_read(EEPROM_TYPE, FILTER_NUMBER_ADDR);
    fnode.lastFlushPhase = ((uint16_t)fnode.filterNumber * 4) + 1;

    // Sayaç mevcuts ISR'yi aktifle
    if ((fnode.systemSetup >> 3) & 1 == 1) {

        watermeterInterrupt.rise(&watermeter_isr);

    }

    // EEPROM'dan sulama sırasında veri gönderim sıklığını oku
    fnode.irriTransmitInterval = eeprom_read(EEPROM_TYPE, IRRI_TRANSMIT_INTERVAL_ADDR);

    // EEPROM'dan sulama dışında veri gönderim sıklığını oku
    fnode.dryTransmitInterval = eeprom_read(EEPROM_TYPE, DRY_TRANSMIT_INTERVAL_ADDR);

    // EEPROM'dan otomatik veri gönderimini oku
    if (eeprom_read(EEPROM_TYPE, AUTOSEND_STATUS_ADDR) == 1) {

        fnode.autosend = true;

    } else {

        fnode.autosend = false;

    }

    if (eeprom_read(EEPROM_TYPE, IRRI_STATUS_ADDR) == 1) {

        fnode.irrigation = true;

        dataTransmitTicker.attach(&data_transmit_isr, fnode.irriTransmitInterval * 60);

        timer.reset();
        timer.start();

    } else {

        fnode.irrigation = false;

        dataTransmitTicker.attach(&data_transmit_isr, fnode.dryTransmitInterval * 60);

        timer.reset();
        timer.start();

    }

    // EEPROM'dan sayaç katsayısını oku
    fnode.watermeterCoefficient = (eeprom_read(EEPROM_TYPE, WATERMETER_COEFF_ADDR_1) << 8) + eeprom_read(EEPROM_TYPE, WATERMETER_COEFF_ADDR_2);

    // EEPROM'dan basınç sensörünün okuyabileceği maksimum basıncı oku
    fnode.pMax = eeprom_read(EEPROM_TYPE, PMAX_ADDR);

    // EEPROM'dan basınç sensörü tipini oku (4-20 mA veya 0-3.3v)
    fnode.pressureSensorType = eeprom_read(EEPROM_TYPE, PRESSURE_SENSOR_ADDR);

    // EEPROM'dan DP set değerini oku
    fnode.dpSet = eeprom_read(EEPROM_TYPE, DP_ADDR);

    // EEPROM'dan basınç kontrol sıklığını oku
    fnode.pressureControlFrequency = eeprom_read(EEPROM_TYPE, PRESSURE_CONTROL_FREQUENCY_ADDR);

    // EEPROM'dan 1 filtre yıkama süresini oku
    fnode.flushDuration = eeprom_read(EEPROM_TYPE, FLUSH_DURATION_ADDR);

    // EEPROM'dan 2 filtre yıkaması arasındaki bekleme süresini oku
    fnode.flushInterval = eeprom_read(EEPROM_TYPE, FLUSH_INTERVAL_ADDR);

    // EEPROM'dan akış kontrolü gecikme süresini oku (Akış kontrolü filtre yıkaması başladıktan ya da bittikten kaç saniye sonra yapılacak?)
    fnode.flowControlLatency = eeprom_read(EEPROM_TYPE, FLOW_CONTROL_LATENCY_ADDR);

    // EEPROM'dan ters yıkama kontrolü aktif ya da pasif durumunu oku
    if (eeprom_read(EEPROM_TYPE, FLUSH_ENABLE_ADDR) == 1) {

        fnode.flushEnabled = 1;

    } else {

        fnode.flushEnabled = 0;

    }

    // EEPROM'dan basınç sensörünün yerleştirme noktasını oku (Filtre öncesi ya da sonrası)
    fnode.pressureSensorPosition = eeprom_read(EEPROM_TYPE, PR_SENSOR_POSITION_ADDR);

    // EEPROM'dan hata durumunda ters yıkamanın durdurulup durdurulmayacağını oku
    if (eeprom_read(EEPROM_TYPE, BACKFLUSH_STOP_ADDR) == 0) {

        fnode.onErrorStop = 0;

    } else {

        fnode.onErrorStop = 1;

    }

    fnode.pressureLowThreshold = eeprom_read(EEPROM_TYPE, INLET_PRS_LOW_TRS_ADDR);
    fnode.pressureHighThreshold = eeprom_read(EEPROM_TYPE, INLET_PRS_HIGH_TRS_ADDR);

    // Timer ve tickerları başlat
    // Basınç sürekli kontrol edilecek
    pressureCheckTicker.attach(&pressure_check_isr, fnode.pressureControlFrequency);

    // EEPROM'dan alarmların açık/kapalı durumunu oku
    if (eeprom_read(EEPROM_TYPE, ALARMS_ENABLE_ADDR) == 0) {

        fnode.alarmsEnabled = 0;

    } else {

        fnode.alarmsEnabled = 1;

    }

    // EEPROM'dan DP alarmı eşik değerini oku
    // Yıkama sırasında DP bu değerin üstüne çıkarsa alarm gönderilir
    // Bazı durumlarda DP düşmeyebilir !!!
    fnode.dpThreshold = eeprom_read(EEPROM_TYPE, DP_HIGH_TRS_ADDR);

    // EEPROM'dan sulamanın başladığının anlaşılacağı giriş basıncı set değerini oku
    fnode.inletPressureSet = eeprom_read(EEPROM_TYPE, INLET_PRS_SET_ADDR);

    // EEPROM'dan DP kontrolünün başlayacağı filtrasyon çıkış basıncı set değerini oku
    fnode.outletPressureSet = eeprom_read(EEPROM_TYPE, OUTLET_PRS_SET_FOR_DP_ADDR);

    // periodicFlushInterval değeri 0 ise periyodik yıkama yapılmaz
    fnode.periodicFlushInterval = eeprom_read(EEPROM_TYPE, PERIODIC_FLUSH_ADDR);

    if (fnode.periodicFlushInterval == 0) {

        fnode.periodicFlushEnabled = false;
        periodicFlushTicker.detach();
        fnode.periodicFlushCounter = 0;

    } else {

        fnode.periodicFlushEnabled = true;
        fnode.periodicFlushCounter = 0;

        // Periodic flush isr works every 1 second to increase periodicCounter by 1
        // If periodicCounter value >= peridicFlushInterval * 3600
        // Example:
        // Periodic flush interval is 6 hours
        // Periodic counter counts every 1 seconds by ISR
        // In 1 hour there is 3600 seconds..... In 6 hours 6 * 3600 = 21600 seconds

        if (fnode.irrigation == true) {

            periodicFlushTicker.attach(&periodic_flush_isr, 1);                               // ISR set every 1 second

        } else {

            periodicFlushTicker.detach();

        }
    }

    // minFlushInterval değeri 0'dan farklı ise DP yıkamaları min süre beklenerek yapılır
    c23_a = eeprom_read(EEPROM_TYPE, MIN_FLUSH_INTERVAL_ADDR_1);
    c23_b = eeprom_read(EEPROM_TYPE, MIN_FLUSH_INTERVAL_ADDR_2);
    fnode.minFlushInterval = (c23_a << 8) + c23_b;

    if (fnode.minFlushInterval == 0) {

        fnode.minFlushEnabled = false;

    } else {

        fnode.minFlushEnabled = true;
    }

    if (fnode.filterNumber % 4 == 0) {

        fnode.totalSlaveNumber = fnode.filterNumber / 4;

    } else {

        fnode.totalSlaveNumber = (fnode.filterNumber / 4) + 1;
    }
}

//
float read_pressure_dp()
{
    // Analog kanal okumasının RMS (Root Mean Square) hesaplaması
    memset(rmsStore, 0, sizeof(rmsStore));
    totalSampling = 0.0;
    tempValue = 0.0;
    tdp = 0.0;

    for (uint8_t b = 0; b < RMS_SAMPLING_NUMBER; b++) {

        tempValue = dpSensor.read();
        rmsStore[b] = tempValue * tempValue;
        totalSampling = totalSampling + rmsStore[b];

    }

    tdp = (sqrt ((float)((totalSampling / RMS_SAMPLING_NUMBER)))) * 4096.0f;
    //

    // Fark basınç hesaplaması, BAR, -4 ile +4 bar arası
    // DP + 4 = ((Sensor okuması - 409.6) / 409.6) ==> Honeywell sensor katalog sadeleştirilmiş denklem
    tdpResult = ((tdp-409.6f)/409.6f) - 4.0f;

    if (tdpResult < 0) {

        tdpResult = 0;

    }

    tdpResult = floor(tdpResult * 10) / 10;

    return tdpResult;
}

//
float read_pressure()
{
    // Analog kanal okumasının RMS (Root Mean Square) hesaplaması
    memset(rmsStore, 0, sizeof(rmsStore));
    totalSampling = 0;
    tempValue = 0;
    tp = 0;

    for (uint8_t b = 0; b < RMS_SAMPLING_NUMBER; b++) {

        tempValue = pressureSensor.read();
        rmsStore[b] = tempValue * tempValue;
        totalSampling = totalSampling + rmsStore[b];

    }

    tp = (sqrt ((float)((totalSampling / RMS_SAMPLING_NUMBER)))) * 4096.0f;
    //

    if (fnode.pressureSensorType == 0) {

        // Ham analog verisinden basınç hesaplaması, BAR
        // Honeywell Truw Stability sensörlerine özel, PSI, 3.3v, map'lenmemiş
        tp = ((tp - 409.6f) / (3276.8f / (float)fnode.pMax)) * 0.0689476f; // 0.0689 is for psi to bar conversion;

    } else {

        // Ham analog verisinden basınç hesaplaması, BAR
        // 4-20 mA sensöre özel, BAR
        // 4 mA = 480 mV = 595.8 RAW
        // 20 mA = 2400 mV = 2978.9 RAW
        tp = map (tp, 595.8f, 2978.9f, 0.0f, (float)fnode.pMax);

    }

    if (tp < 0) {

        tp = 0;

    }

    tp = floor(tp * 10) / 10;

    return tp;
}

void prepare_data_fread()
{
    memset(fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));
    memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

    // Filtrasyon JSON headırını yaz
    sprintf(fnode.temporaryBuffer, "%s", json[0]);
    strcat(fnode.dataBuffer, fnode.temporaryBuffer);
    memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

    // Eğer basınç sensörü varsa
    if (fnode.systemSetup & (1 << 1)) {

        // Basınç sensörü varken DP sensörü de mevcutsa hem giriş hem çıkış basıncını yaz
        if (fnode.systemSetup & (1 << 1)) {

            sprintf(fnode.temporaryBuffer, "%s%.1f%c%s%.1f%c", jsonHeader[0], fnode.inletPressure, ',', jsonHeader[1], fnode.outletPressure, ',');
            strcat(fnode.dataBuffer, fnode.temporaryBuffer);
            memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

            // Basınç sensörü varken DP sensörü yoksa basınç sensörünün pozisyonuna göre giriş veya çıkış basıncını yaz
        } else {

            // Basınç sensörü girişte ise giriş basıncını yaz, çıkış basıncı NULL olsun
            if (fnode.systemSetup & (1 << 1) && fnode.pressureSensorPosition == 0) {

                sprintf(fnode.temporaryBuffer, "%s%.1f%c%s%s%c", jsonHeader[0], fnode.inletPressure, ',', jsonHeader[1], "null", ',');
                strcat(fnode.dataBuffer, fnode.temporaryBuffer);
                memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

                // Basınç sensörü çıkışta ise çıkış basıncını yaz, giriş basıncı NULL olsun
            } else if (fnode.systemSetup & (1 << 1) && fnode.pressureSensorPosition == 1) {

                sprintf(fnode.temporaryBuffer, "%s%s%c%s%.1f%c", jsonHeader[0], "null", ',', jsonHeader[1], fnode.outletPressure, ',');
                strcat(fnode.dataBuffer, fnode.temporaryBuffer);
                memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

            }
        }

        // Basınç sensörü yoksa giriş ve çıkış basınç değerleri NULL olsun
    } else {

        sprintf(fnode.temporaryBuffer, "%s%s%c%s%s%c", jsonHeader[0], "null", ',', jsonHeader[1], "null", ',');
        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));
    }

    // Eğer DP sensörü varsa DP verisini ekle
    if (fnode.systemSetup & (1 << 1)) {

        sprintf(fnode.temporaryBuffer, "%s%.1f%c", jsonHeader[2], fnode.dpPressure, ',');
        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

        // DP sensörü yoksa DP verisi NULL olsun
    } else {

        sprintf(fnode.temporaryBuffer, "%s%s%c", jsonHeader[2], "null", ',');
        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

    }

    // Eğer sayaç mevcutsa su hacmi ve debi verilerini ekle
    // İki veri gönderimi arasındaki su hacmi ve debi verisini burada hesapla
    if (fnode.systemSetup & (1 << 3)) {

        sprintf(fnode.temporaryBuffer, "%s%llu%c%s%llu%c%s%.1f%c%s%llu%c%s%llu%c%s%.1f", jsonHeader[3], fnode.rWI, ',', jsonHeader[4], fnode.rWIC, ',', jsonHeader[5], fnode.rQI, ',', jsonHeader[6], fnode.rWD, ',', jsonHeader[7], fnode.rWDC, ',', jsonHeader[8], fnode.rQD);
        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));


    } else {

        sprintf(fnode.temporaryBuffer, "%s%s%c%s%s%c%s%s%c%s%s%c%s%s%c%s%s", jsonHeader[3], "null", ',', jsonHeader[4], "null", ',', jsonHeader[5], "null", ',', jsonHeader[6], "null", ',', jsonHeader[7], "null", ',', jsonHeader[8], "null");
        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

    }

    // Sulama durumu
    if (fnode.irrigation == true) {

        sprintf(fnode.temporaryBuffer, "%s", ",STAT:\"IRR\"");
        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

    } else {

        sprintf(fnode.temporaryBuffer, "%s", ",STAT:\"DRY\"");
        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

    }

    // Yıkama durumu
    if (fnode.flushing == true) {

        sprintf(fnode.temporaryBuffer, "%s", ",FSTAT:1");
        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

    } else {

        sprintf(fnode.temporaryBuffer, "%s", ",FSTAT:0");
        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

    }

    sprintf(fnode.temporaryBuffer, "%s", "},RT:1}");

    strcat(fnode.dataBuffer, fnode.temporaryBuffer);
    memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));
}


//
void prepare_data()
{
    memset(fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));
    memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

    // Filtrasyon JSON headırını yaz
    sprintf(fnode.temporaryBuffer, "%s", json[0]);
    strcat(fnode.dataBuffer, fnode.temporaryBuffer);
    memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

    // Eğer basınç sensörü varsa
    if (fnode.systemSetup & (1 << 1)) {

        // Basınç sensörü varken DP sensörü de mevcutsa hem giriş hem çıkış basıncını yaz
        if (fnode.systemSetup & (1 << 0)) {

            sprintf(fnode.temporaryBuffer, "%s%.1f%c%s%.1f%c", jsonHeader[0], fnode.inletPressure, ',', jsonHeader[1], fnode.outletPressure, ',');
            strcat(fnode.dataBuffer, fnode.temporaryBuffer);
            memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

            // Basınç sensörü varken DP sensörü yoksa basınç sensörünün pozisyonuna göre giriş veya çıkış basıncını yaz
        } else {

            // Basınç sensörü girişte ise giriş basıncını yaz, çıkış basıncı NULL olsun
            if (fnode.systemSetup & (1 << 1) && fnode.pressureSensorPosition == 0) {

                sprintf(fnode.temporaryBuffer, "%s%.1f%c%s%s%c", jsonHeader[0], fnode.inletPressure, ',', jsonHeader[1], "null", ',');
                strcat(fnode.dataBuffer, fnode.temporaryBuffer);
                memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

                // Basınç sensörü çıkışta ise çıkış basıncını yaz, giriş basıncı NULL olsun
            } else if (fnode.systemSetup & (1 << 1) && fnode.pressureSensorPosition == 1) {

                sprintf(fnode.temporaryBuffer, "%s%s%c%s%.1f%c", jsonHeader[0], "null", ',', jsonHeader[1], fnode.outletPressure, ',');
                strcat(fnode.dataBuffer, fnode.temporaryBuffer);
                memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

            }
        }

        // Basınç sensörü yoksa giriş ve çıkış basınç değerleri NULL olsun
    } else {

        sprintf(fnode.temporaryBuffer, "%s%s%c%s%s%c", jsonHeader[0], "null", ',', jsonHeader[1], "null", ',');
        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));
    }

    // Eğer DP sensörü varsa DP verisini ekle
    if (fnode.systemSetup & (1 << 0)) {

        sprintf(fnode.temporaryBuffer, "%s%.1f%c", jsonHeader[2], fnode.dpPressure, ',');
        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

        // DP sensörü yoksa DP verisi NULL olsun
    } else {

        sprintf(fnode.temporaryBuffer, "%s%s%c", jsonHeader[2], "null", ',');
        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

    }

    // Eğer sayaç mevcutsa su hacmi ve debi verilerini ekle
    // İki veri gönderimi arasındaki su hacmi ve debi verisini burada hesapla
    if (fnode.systemSetup & (1 << 3)) {

        sprintf(fnode.temporaryBuffer, "%s%llu%c%s%llu%c%s%.1f%c%s%llu%c%s%llu%c%s%.1f", jsonHeader[3], fnode.WI, ',', jsonHeader[4], fnode.WIC, ',', jsonHeader[5], fnode.QI, ',', jsonHeader[6], fnode.WD, ',', jsonHeader[7], fnode.WDC, ',', jsonHeader[8], fnode.QD);
        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));


    } else {

        sprintf(fnode.temporaryBuffer, "%s%s%c%s%s%c%s%s%c%s%s%c%s%s%c%s%s", jsonHeader[3], "null", ',', jsonHeader[4], "null", ',', jsonHeader[5], "null", ',', jsonHeader[6], "null", ',', jsonHeader[7], "null", ',', jsonHeader[8], "null");
        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

    }

    // Sulama durumu
    if (fnode.irrigation == true) {

        sprintf(fnode.temporaryBuffer, "%s", ",STAT:\"IRR\"");
        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

    } else {

        sprintf(fnode.temporaryBuffer, "%s", ",STAT:\"DRY\"");
        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

    }

    // Yıkama durumu
    if (fnode.flushing == true) {

        sprintf(fnode.temporaryBuffer, "%s", ",FSTAT:1");
        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

    } else {

        sprintf(fnode.temporaryBuffer, "%s", ",FSTAT:0");
        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

    }

    sprintf(fnode.temporaryBuffer, "%s", "}}");

    strcat(fnode.dataBuffer, fnode.temporaryBuffer);
    memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));
}

//
void send_to_coordinator(char* char_array)
{
    rf.putc(COORD_ADDR_1);
    rf.putc(COORD_ADDR_2);
    rf.putc(EQUAL);
    rf.puts(char_array);
    rf.putc(CR);
    wait_ms(50);
}

//
void process_command(uint8_t cmnd)
{
    switch(cmnd) {

        case FENABLE: {

            // Eğer ters yıkama zaten akitflenmişse hata mesajı gönder
            if (eeprom_read(EEPROM_TYPE, FLUSH_ENABLE_ADDR) == 1) {

                sprintf(fnode.dataBuffer, "%s", "{CMD:\"FENABLEERR\"}");
                send_to_coordinator(fnode.dataBuffer);
                memset (fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));

                // Ters yıkamayı devre dışı bırak
            } else {

                // Yıkamanın devreye alındığını EEPROM'a yaz
                eeprom_write(EEPROM_TYPE, FLUSH_ENABLE_ADDR, 1);

                fnode.flushEnabled = 1;

                sprintf(fnode.dataBuffer, "%s", "{CMD:\"FENABLEOK\"}");
                send_to_coordinator(fnode.dataBuffer);
                memset (fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));

            }
        }
        break;

        case FDISABLE: {

            // Eğer ters yıkama zaten akitflenmişse hata mesajı gönder
            if (eeprom_read(EEPROM_TYPE, FLUSH_ENABLE_ADDR) == 0) {

                sprintf(fnode.dataBuffer, "%s", "{CMD:\"FDISABLEERR\"}");
                send_to_coordinator(fnode.dataBuffer);
                memset (fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));

                // Ters yıkamayı devre dışı bırak
            } else {

                // Yıkamanın devre dışı kaldığını EEPROM'a yaz
                eeprom_write(EEPROM_TYPE, FLUSH_ENABLE_ADDR, 0);

                fnode.flushEnabled = 0;

                /*
                // Yıkama zamanlayıcısını kapat
                flushTimer.detach();

                // Yıkama fazını sıfırla
                fnode.flushPhase = 0;

                // Solenoid vanaları kontrol et ve kapat
                check_and_close_valves();
                */

                sprintf(fnode.dataBuffer, "%s", "{CMD:\"FDISABLEOK\"}");
                send_to_coordinator(fnode.dataBuffer);
                memset (fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));

            }
        }
        break;

        case FSETSYS: {

            // Sistem ayarları
            eeprom_write(EEPROM_TYPE, SYSTEM_SETUP_ADDR, fnode.systemSetup);

            // Otomatik veri aktarımı
            eeprom_write(EEPROM_TYPE, AUTOSEND_STATUS_ADDR, fnode.autosendStatus);

            // Yeni set edilecek veri aktarım aralıkları eskisinden farklıysa zamanlayıcıları yeni ayarla başlat
            // Eski ile yeni aktarım aralıkları aynı ise değişiklik yapma (Alt satırlarda)
            irriTrsIntOld = eeprom_read(EEPROM_TYPE, IRRI_TRANSMIT_INTERVAL_ADDR);
            eeprom_write(EEPROM_TYPE, IRRI_TRANSMIT_INTERVAL_ADDR, fnode.irriTransmitInterval);

            dryTrsIntOld = eeprom_read(EEPROM_TYPE, DRY_TRANSMIT_INTERVAL_ADDR);
            eeprom_write(EEPROM_TYPE, DRY_TRANSMIT_INTERVAL_ADDR, fnode.dryTransmitInterval);

            // Sayaç katsayısı
            eeprom_write(EEPROM_TYPE, WATERMETER_COEFF_ADDR_1, fnode.watermeterCoefficient >> 8);
            eeprom_write(EEPROM_TYPE, WATERMETER_COEFF_ADDR_2, fnode.watermeterCoefficient & 0xFF);

            // Basınç sensörü maksimum basıncı
            eeprom_write(EEPROM_TYPE, PMAX_ADDR, fnode.pMax);

            // Basınç sensörü tipi
            eeprom_write(EEPROM_TYPE, PRESSURE_SENSOR_ADDR, fnode.pressureSensorType);

            // DP set
            eeprom_write(EEPROM_TYPE, DP_ADDR, fnode.dpSet);

            // Basınç kontrol sıklığı
            eeprom_write(EEPROM_TYPE, PRESSURE_CONTROL_FREQUENCY_ADDR, fnode.pressureControlFrequency);

            // 1 filtre yıkama süresi
            eeprom_write(EEPROM_TYPE, FLUSH_DURATION_ADDR, fnode.flushDuration);

            // Yıkama aralığı
            eeprom_write(EEPROM_TYPE, FLUSH_INTERVAL_ADDR, fnode.flushInterval);

            // Akış kontrol gecikmesi
            eeprom_write(EEPROM_TYPE, FLOW_CONTROL_LATENCY_ADDR, fnode.flowControlLatency);

            // Ters yıkama devrede/devrede değil
            eeprom_write(EEPROM_TYPE, FLUSH_ENABLE_ADDR, fnode.flushEnabled);

            // Basınç sensörü pozisyonu
            eeprom_write(EEPROM_TYPE, PR_SENSOR_POSITION_ADDR, fnode.pressureSensorPosition);

            // Hata durumunda ters yıkamayı durdur/durdurma
            eeprom_write(EEPROM_TYPE, BACKFLUSH_STOP_ADDR, fnode.onErrorStop);

            // Giriş basıncı alarm alt sınır eşik
            eeprom_write(EEPROM_TYPE, INLET_PRS_LOW_TRS_ADDR, fnode.pressureLowThreshold);

            // Giriş basıncı alarm üst sınır eşik
            eeprom_write(EEPROM_TYPE, INLET_PRS_HIGH_TRS_ADDR, fnode.pressureHighThreshold);

            // Alarmlar devrede
            eeprom_write(EEPROM_TYPE, ALARMS_ENABLE_ADDR, fnode.alarmsEnabled);

            // DP alarm eşik değeri
            eeprom_write(EEPROM_TYPE, DP_HIGH_TRS_ADDR, fnode.dpThreshold);

            eeprom_write(EEPROM_TYPE, INLET_PRS_SET_ADDR, fnode.inletPressureSet);

            eeprom_write(EEPROM_TYPE, OUTLET_PRS_SET_FOR_DP_ADDR, fnode.outletPressureSet);

            eeprom_write(EEPROM_TYPE, PERIODIC_FLUSH_ADDR, fnode.periodicFlushInterval);

            eeprom_write(EEPROM_TYPE, MIN_FLUSH_INTERVAL_ADDR_1, fnode.minFlushInterval >> 8);
            eeprom_write(EEPROM_TYPE, MIN_FLUSH_INTERVAL_ADDR_2, fnode.minFlushInterval & 0xFF);

            eeprom_write(EEPROM_TYPE, FILTER_NUMBER_ADDR, fnode.filterNumber);


            // Check written SSETSYS values on EEPROM
            c1 = eeprom_read(EEPROM_TYPE, SYSTEM_SETUP_ADDR);
            c2 = eeprom_read(EEPROM_TYPE, AUTOSEND_STATUS_ADDR);
            c3 = eeprom_read(EEPROM_TYPE, IRRI_TRANSMIT_INTERVAL_ADDR);
            c4 = eeprom_read(EEPROM_TYPE, DRY_TRANSMIT_INTERVAL_ADDR);
            c5_a = eeprom_read(EEPROM_TYPE, WATERMETER_COEFF_ADDR_1);
            c5_b = eeprom_read(EEPROM_TYPE, WATERMETER_COEFF_ADDR_2);
            c5 = (c5_a << 8) + c5_b;
            c6 = eeprom_read(EEPROM_TYPE, PMAX_ADDR);
            c7 = eeprom_read(EEPROM_TYPE, PRESSURE_SENSOR_ADDR);
            c8 = eeprom_read(EEPROM_TYPE, DP_ADDR);
            c9 = eeprom_read(EEPROM_TYPE, PRESSURE_CONTROL_FREQUENCY_ADDR);
            c10 = eeprom_read(EEPROM_TYPE, FLUSH_DURATION_ADDR);
            c11 = eeprom_read(EEPROM_TYPE, FLUSH_INTERVAL_ADDR);
            c12 = eeprom_read(EEPROM_TYPE, FLOW_CONTROL_LATENCY_ADDR);
            c13 = eeprom_read(EEPROM_TYPE, FLUSH_ENABLE_ADDR);
            c14 = eeprom_read(EEPROM_TYPE, PR_SENSOR_POSITION_ADDR);
            c15 = eeprom_read(EEPROM_TYPE, BACKFLUSH_STOP_ADDR);
            c16 = eeprom_read(EEPROM_TYPE, INLET_PRS_LOW_TRS_ADDR);
            c17 = eeprom_read(EEPROM_TYPE, INLET_PRS_HIGH_TRS_ADDR);
            c18 = eeprom_read(EEPROM_TYPE, ALARMS_ENABLE_ADDR);
            c19 = eeprom_read(EEPROM_TYPE, DP_HIGH_TRS_ADDR);
            c20 = eeprom_read(EEPROM_TYPE, INLET_PRS_SET_ADDR);
            c21 = eeprom_read(EEPROM_TYPE, OUTLET_PRS_SET_FOR_DP_ADDR);
            c22 = eeprom_read(EEPROM_TYPE, PERIODIC_FLUSH_ADDR);
            c23_a = eeprom_read(EEPROM_TYPE, MIN_FLUSH_INTERVAL_ADDR_1);
            c23_b = eeprom_read(EEPROM_TYPE, MIN_FLUSH_INTERVAL_ADDR_2);
            c23 = (c23_a << 8) + c23_b;
            c24 = eeprom_read(EEPROM_TYPE, FILTER_NUMBER_ADDR);

            // Kaydedilen değerler ile gönderilen değerleri karşılaştır
            // Aynı ise sunucuya mesaj gönder
            if (c1 == fnode.systemSetup && c2 == fnode.autosendStatus && c3 == fnode.irriTransmitInterval && c4 == fnode.dryTransmitInterval && c5 == fnode.watermeterCoefficient && c6 == fnode.pMax && c7 == fnode.pressureSensorType && c8 == fnode.dpSet && c9 == fnode.pressureControlFrequency && c10 == fnode.flushDuration && c11 == fnode.flushInterval && c12 == fnode.flowControlLatency && c13 == fnode.flushEnabled && c14 == fnode.pressureSensorPosition && c15 == fnode.onErrorStop && c16 == fnode.pressureLowThreshold && c17 == fnode.pressureHighThreshold && c18 == fnode.alarmsEnabled && c19 == fnode.dpThreshold && c20 == fnode.inletPressureSet && c21 == fnode.outletPressureSet && c22 == fnode.periodicFlushInterval && c23 == fnode.minFlushInterval && c24 == fnode.filterNumber) {

                sprintf(fnode.dataBuffer, "%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%c", "{CMD:\"FSETSYSOK\",C1:", c1, ",C2:", c2, ",C3:", c3, ",C4:", c4, ",C5:", c5, ",C6:", c6, ",C7:", c7, ",C8:", c8, ",C9:", c9, ",C10:", c10, ",C11:", c11, ",C12:", c12, ",C13:", c13, ",C14:", c14, ",C15:", c15, ",C16:", c16, ",C17:", c17, ",C18:", c18, ",C19:", c19, ",C20:", c20, ",C21:", c21, ",C22:", c22, ",C23:", c23, ",C24:", c24, '}');
                send_to_coordinator(fnode.dataBuffer);
                memset (fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));

                // YENİ SET Değerlerine göre ayarlar
                // Filtre sayısı
                fnode.filterNumber = c24;
                fnode.lastFlushPhase = ((uint16_t)fnode.filterNumber * 4) + 1;

                // Sayaç mevcutsa ISR'yi aktifle
                if (fnode.systemSetup & (1 << 3)) {

                    watermeterInterrupt.rise(NULL);
                    watermeterInterrupt.rise(&watermeter_isr);

                } else {

                    watermeterInterrupt.rise(NULL);
                }

                if (fnode.autosendStatus == 0) {

                    fnode.autosend = false;

                } else {

                    fnode.autosend = true;
                }

                // If irrigation phase and autosend is active and new data transmission interval is different than old one attach data transmission ISR again
                if (fnode.irrigation == true && fnode.autosend == true && irriTrsIntOld != fnode.irriTransmitInterval) {

                    dataTransmitTicker.detach();
                    dataTransmitTicker.attach(&data_transmit_isr, fnode.irriTransmitInterval * 60);

                    // If not irrigation phase and autosend is active and new data transmission interval is different than old one attach data transmission ISR again
                } else if (fnode.irrigation == false && fnode.autosend == true && dryTrsIntOld != fnode.dryTransmitInterval) {

                    dataTransmitTicker.detach();
                    dataTransmitTicker.attach(&data_transmit_isr, fnode.dryTransmitInterval * 60);

                    // If autosend is not active detach data transmission ISR
                } else if (fnode.autosend == false) {

                    dataTransmitTicker.detach();

                }

                // periodicFlushInterval değeri 0 ise periyodik yıkama yapılmaz
                if (fnode.periodicFlushInterval == 0) {

                    fnode.periodicFlushEnabled = false;
                    periodicFlushTicker.detach();
                    fnode.periodicFlushCounter = 0;

                } else {

                    fnode.periodicFlushEnabled = true;
                    fnode.periodicFlushCounter = 0;

                    // Periodic flush isr works every 1 second to increase periodicCounter by 1
                    // If periodicCounter value >= peridicFlushInterval * 3600
                    // Example:
                    // Periodic flush interval is 6 hours
                    // Periodic counter counts every 1 seconds by ISR
                    // In 1 hour there is 3600 seconds..... In 6 hours 6 * 3600 = 21600 seconds

                    if (fnode.irrigation == true) {

                        periodicFlushTicker.attach(&periodic_flush_isr, 1);                               // ISR set every 1 second

                    } else {

                        periodicFlushTicker.detach();

                    }
                }

                // minFlushInterval değeri 0'dan farklı ise DP yıkamaları min süre beklenerek yapılır
                if (fnode.minFlushInterval == 0) {

                    fnode.minFlushEnabled = false;

                } else {

                    fnode.minFlushEnabled = true;
                }

            } else {

                sprintf(fnode.dataBuffer, "%s", "{CMD:\"FSETSYSERR\"}");
                send_to_coordinator(fnode.dataBuffer);
                memset (fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));

            }
        }
        break;

        case FGETCFG: {

            // Get configuration from EEPROM
            c1 = eeprom_read(EEPROM_TYPE, SYSTEM_SETUP_ADDR);
            c2 = eeprom_read(EEPROM_TYPE, AUTOSEND_STATUS_ADDR);
            c3 = eeprom_read(EEPROM_TYPE, IRRI_TRANSMIT_INTERVAL_ADDR);
            c4 = eeprom_read(EEPROM_TYPE, DRY_TRANSMIT_INTERVAL_ADDR);
            c5_a = eeprom_read(EEPROM_TYPE, WATERMETER_COEFF_ADDR_1);
            c5_b = eeprom_read(EEPROM_TYPE, WATERMETER_COEFF_ADDR_2);
            c5 = (c5_a << 8) + c5_b;
            c6 = eeprom_read(EEPROM_TYPE, PMAX_ADDR);
            c7 = eeprom_read(EEPROM_TYPE, PRESSURE_SENSOR_ADDR);
            c8 = eeprom_read(EEPROM_TYPE, DP_ADDR);
            c9 = eeprom_read(EEPROM_TYPE, PRESSURE_CONTROL_FREQUENCY_ADDR);
            c10 = eeprom_read(EEPROM_TYPE, FLUSH_DURATION_ADDR);
            c11 = eeprom_read(EEPROM_TYPE, FLUSH_INTERVAL_ADDR);
            c12 = eeprom_read(EEPROM_TYPE, FLOW_CONTROL_LATENCY_ADDR);
            c13 = eeprom_read(EEPROM_TYPE, FLUSH_ENABLE_ADDR);
            c14 = eeprom_read(EEPROM_TYPE, PR_SENSOR_POSITION_ADDR);
            c15 = eeprom_read(EEPROM_TYPE, BACKFLUSH_STOP_ADDR);
            c16 = eeprom_read(EEPROM_TYPE, INLET_PRS_LOW_TRS_ADDR);
            c17 = eeprom_read(EEPROM_TYPE, INLET_PRS_HIGH_TRS_ADDR);
            c18 = eeprom_read(EEPROM_TYPE, ALARMS_ENABLE_ADDR);
            c19 = eeprom_read(EEPROM_TYPE, DP_HIGH_TRS_ADDR);
            c20 = eeprom_read(EEPROM_TYPE, INLET_PRS_SET_ADDR);
            c21 = eeprom_read(EEPROM_TYPE, OUTLET_PRS_SET_FOR_DP_ADDR);
            c22 = eeprom_read(EEPROM_TYPE, PERIODIC_FLUSH_ADDR);
            c23_a = eeprom_read(EEPROM_TYPE, MIN_FLUSH_INTERVAL_ADDR_1);
            c23_b = eeprom_read(EEPROM_TYPE, MIN_FLUSH_INTERVAL_ADDR_2);
            c23 = (c23_a << 8) + c23_b;
            c24 = eeprom_read(EEPROM_TYPE, FILTER_NUMBER_ADDR);

            sprintf(fnode.dataBuffer, "%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%s%d%c", "{CMD:\"FGETCFGOK\",C1:", c1, ",C2:", c2, ",C3:", c3, ",C4:", c4, ",C5:", c5, ",C6:", c6, ",C7:", c7, ",C8:", c8, ",C9:", c9, ",C10:", c10, ",C11:", c11, ",C12:", c12, ",C13:", c13, ",C14:", c14, ",C15:", c15, ",C16:", c16, ",C17:", c17, ",C18:", c18, ",C19:", c19, ",C20:", c20, ",C21:", c21,  ",C22:", c22, ",C23:", c23, ",C24:", c24, '}');
            send_to_coordinator(fnode.dataBuffer);
            memset (fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));

        }
        break;

        case FSTART: {

            if (fnode.autosend == false) {

                fnode.autosend = true;

                if (fnode.irrigation) {

                    dataTransmitTicker.detach();
                    dataTransmitTicker.attach(&data_transmit_isr, fnode.irriTransmitInterval * 60);

                } else {

                    dataTransmitTicker.detach();
                    dataTransmitTicker.attach(&data_transmit_isr, fnode.dryTransmitInterval * 60);

                }

                // Save autosend enable status to EEPROM
                eeprom_write(EEPROM_TYPE, AUTOSEND_STATUS_ADDR, 1);

                sprintf(fnode.dataBuffer, "%s", "{CMD:\"FSTARTOK\"}");
                send_to_coordinator(fnode.dataBuffer);
                memset (fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));

            } else {

                sprintf(fnode.dataBuffer, "%s", "{CMD:\"FSTARTERR\"}");
                send_to_coordinator(fnode.dataBuffer);
                memset (fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));

            }

        }
        break;


        case FSTOP: {

            if (fnode.autosend == true) {

                fnode.autosend = false;

                dataTransmitTicker.detach();

                // Save autosend disable status to EEPROM
                eeprom_write(EEPROM_TYPE, AUTOSEND_STATUS_ADDR, 0);

                sprintf(fnode.dataBuffer, "%s", "{CMD:\"FSTOPOK\"}");
                send_to_coordinator(fnode.dataBuffer);
                memset (fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));

            } else {

                sprintf(fnode.dataBuffer, "%s", "{CMD:\"FSTOPERR\"}");
                send_to_coordinator(fnode.dataBuffer);
                memset (fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));

            }
        }
        break;

        case FFIX: {

            if (fnode.errorOccured == true) {

                fnode.errorOccured = false;

                sprintf(fnode.dataBuffer, "%s", "{CMD:\"FFIXOK\"}");
                send_to_coordinator(fnode.dataBuffer);
                memset (fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));

            } else {

                sprintf(fnode.dataBuffer, "%s", "{CMD:\"FFIXERR\"}");
                send_to_coordinator(fnode.dataBuffer);
                memset (fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));

            }
        }
        break;

        case FGETSTATUS: {

            //STAT:"IRR"
            if (fnode.irrigation == true) {

                sprintf(fnode.dataBuffer, "%s", "{STAT:\"IRR\"}");
                send_to_coordinator(fnode.dataBuffer);
                memset (fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));

                //STAT:"DRY"
            } else {

                sprintf(fnode.dataBuffer, "%s", "{STAT:\"DRY\"}");
                send_to_coordinator(fnode.dataBuffer);
                memset (fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));

            }

        }
        break;

        case FGETFSTATUS: {

            // Flushing Now
            if(fnode.flushing) {
                sprintf(fnode.dataBuffer, "%s", "{STAT:\"FLUSHING\"}");
                send_to_coordinator(fnode.dataBuffer);
                memset (fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));

            } else {

                sprintf(fnode.dataBuffer, "%s", "{STAT:\"NOTFLUSHING\"}");
                send_to_coordinator(fnode.dataBuffer);
                memset (fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));

            }
        }
        break;

        case FFGETSTAT: {

            memset(fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));
            memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

            // Filtrasyon JSON headırını yaz
            //sprintf(fnode.temporaryBuffer, "%s", json[0]);
            sprintf(fnode.temporaryBuffer, "%s", "{STAT:{");
            strcat(fnode.dataBuffer, fnode.temporaryBuffer);
            memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));
            
            fnode.pressure = read_pressure();
            fnode.dpPressure = read_pressure_dp();

            // Eğer basınç sensörü filtre girişinde ise basınç ve DP değerine göre giriş ve çıkış basıncını hesapla
            // Giriş basıncı = Okunan basınç
            // Çıkış basıncı = Okunan basınç - Fark basınç
            if (fnode.pressureSensorPosition == 0) {

                fnode.inletPressure = fnode.pressure;
                fnode.outletPressure = fnode.pressure - fnode.dpPressure;

                if (fnode.outletPressure < 0) {

                    fnode.outletPressure = 0;

                }

                // Eğer basınç sensörü filtre çıkışında ise basınç ve DP değerine göre giriş ve çıkış basıncını hesapla
                // Giriş basıncı = Okunan basınç + Fark basınç
                // Çıkış basıncı = Okunan basınç
            } else {

                fnode.inletPressure = fnode.pressure + fnode.dpPressure;
                fnode.outletPressure = fnode.pressure;

            }

            // Eğer basınç sensörü varsa
            if (fnode.systemSetup & (1 << 1)) {

                // Basınç sensörü varken DP sensörü de mevcutsa hem giriş hem çıkış basıncını yaz
                if (fnode.systemSetup & (1 << 1)) {

                    sprintf(fnode.temporaryBuffer, "%s%.1f%c%s%.1f%c", jsonHeader[0], fnode.inletPressure, ',', jsonHeader[1], fnode.outletPressure, ',');
                    strcat(fnode.dataBuffer, fnode.temporaryBuffer);
                    memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

                    // Basınç sensörü varken DP sensörü yoksa basınç sensörünün pozisyonuna göre giriş veya çıkış basıncını yaz
                } else {

                    // Basınç sensörü girişte ise giriş basıncını yaz, çıkış basıncı NULL olsun
                    if (fnode.systemSetup & (1 << 1) && fnode.pressureSensorPosition == 0) {

                        sprintf(fnode.temporaryBuffer, "%s%.1f%c%s%s%c", jsonHeader[0], fnode.inletPressure, ',', jsonHeader[1], "null", ',');
                        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
                        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

                        // Basınç sensörü çıkışta ise çıkış basıncını yaz, giriş basıncı NULL olsun
                    } else if (fnode.systemSetup & (1 << 1) && fnode.pressureSensorPosition == 1) {

                        sprintf(fnode.temporaryBuffer, "%s%s%c%s%.1f%c", jsonHeader[0], "null", ',', jsonHeader[1], fnode.outletPressure, ',');
                        strcat(fnode.dataBuffer, fnode.temporaryBuffer);
                        memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

                    }
                }

                // Basınç sensörü yoksa giriş ve çıkış basınç değerleri NULL olsun
            } else {

                sprintf(fnode.temporaryBuffer, "%s%s%c%s%s%c", jsonHeader[0], "null", ',', jsonHeader[1], "null", ',');
                strcat(fnode.dataBuffer, fnode.temporaryBuffer);
                memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));
            }

            // Eğer DP sensörü varsa DP verisini ekle
            if (fnode.systemSetup & (1 << 1)) {

                sprintf(fnode.temporaryBuffer, "%s%.1f", jsonHeader[2], fnode.dpPressure);
                strcat(fnode.dataBuffer, fnode.temporaryBuffer);
                memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

                // DP sensörü yoksa DP verisi NULL olsun
            } else {

                sprintf(fnode.temporaryBuffer, "%s%s", jsonHeader[2], "null");
                strcat(fnode.dataBuffer, fnode.temporaryBuffer);
                memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

            }


            // Sulama durumu
            if (fnode.irrigation == true) {

                sprintf(fnode.temporaryBuffer, "%s", ",STAT:\"IRR\"");
                strcat(fnode.dataBuffer, fnode.temporaryBuffer);
                memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

            } else {

                sprintf(fnode.temporaryBuffer, "%s", ",STAT:\"DRY\"");
                strcat(fnode.dataBuffer, fnode.temporaryBuffer);
                memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

            }

            // Yıkama durumu
            if (fnode.flushing == true) {

                sprintf(fnode.temporaryBuffer, "%s", ",FSTAT:1");
                strcat(fnode.dataBuffer, fnode.temporaryBuffer);
                memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

            } else {

                sprintf(fnode.temporaryBuffer, "%s", ",FSTAT:0");
                strcat(fnode.dataBuffer, fnode.temporaryBuffer);
                memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));

            }

            sprintf(fnode.temporaryBuffer, "%s", "},RT:1}");

            strcat(fnode.dataBuffer, fnode.temporaryBuffer);
            memset (fnode.temporaryBuffer, 0, sizeof(fnode.temporaryBuffer));
            
            send_to_coordinator(fnode.dataBuffer);
            memset (fnode.dataBuffer, 0, sizeof(fnode.dataBuffer));

        }
        break;

        // Elle yıkamayı başlat
        case FLUSHNOW: {

            // Eğer zaten yıkama varsa
            if(fnode.flushing == true) {

                send_alarm(ALREADY_FLUSHING, fnode.globalFlushingFilter, fnode.currentWorkingSlave);

                // Yıkama yoksa başla
            } else if (fnode.flushEnabled == 1 && fnode.errorOccured == false) {

                    periodicFlushTicker.detach();
                    fnode.periodicFlushCounter = 0;

                    fnode.flushing = true;
                    fnode.flushStarted = true;
                    fnode.checkDp = false;

                    minFlushTicker.detach();
                    fnode.minFlushCounter = 0;
                    fnode.isMinTimePassed = false;

                    fnode.globalFlushPhase = 1;
                    fnode.currentFlushPhase = 1;
                    fnode.globalFlushingFilter = 1;
                    fnode.currentFlushingFilter = 1;
                    fnode.currentWorkingSlave = 0;

                    send_alarm(BACKFLUSH_MANUAL_STARTED, fnode.globalFlushingFilter, fnode.currentWorkingSlave);

            } else if (fnode.flushEnabled == 0 && fnode.errorOccured == false) {

                send_alarm(FLUSH_DISABLED, fnode.globalFlushingFilter, fnode.currentWorkingSlave);

            }
        }
        break;
    }
}

bool send_command(uint8_t _slaveid, uint8_t _command, uint8_t _filterid)
{
    bool _ackinit = false;

    if (_slaveid == MASTER_ID) {

        if (_command == OPEN_SOLENOID || _command == TEST_OPEN_SOLENOID) {

            if (open_solenoid(_filterid) == true) {

                _ackinit = true;

            }

        } else if (_command == CLOSE_SOLENOID || _command == TEST_CLOSE_SOLENOID) {

            if (close_solenoid(_filterid)) {

                _ackinit = true;

            }
        }

    } else {

        fnode.masterTxBuffer[0] = MASTER_ID;
        fnode.masterTxBuffer[1] = _slaveid;
        fnode.masterTxBuffer[2] = _command;
        fnode.masterTxBuffer[3] = _filterid;
        fnode.masterTxBuffer[4] = 0x0D;

        for (uint8_t i = 0; i < sizeof(fnode.masterTxBuffer); i++) {

            for (uint8_t j = 0; j < 3; j++) {

                if (master.putc(fnode.masterTxBuffer[i]) == fnode.masterTxBuffer[i]) {

                    _ackinit = true;

                } else {

                    _ackinit = false;

                }

                if (_ackinit == true) {

                    break;

                }
            }

            if (_ackinit == false) {

                break;

            }
        }

        // Slave'den cevap tamamlanıncaya/gelinceye kadar bekle (ISR ile tamamlanır)
        while (fnode.masterInterruptComplete != true) {}

        if (fnode.masterInterruptComplete == true) {

            if (fnode.masterRxBuffer[0] == _OK_) {

                _ackinit = true;

            } else {

                _ackinit  = false;

            }
        }


        memset (fnode.masterRxBuffer, 0, sizeof(fnode.masterRxBuffer));
        master.attach(&master_rx_isr, Serial::RxIrq);

        fnode.masterInterruptComplete = false;
    }

    return _ackinit;
}

// Data aktarım ISR
void data_transmit_isr()
{
    fnode.transmitData = true;
}

// RF Rx ISR
void rf_rx_isr()
{
    fnode.rfBufferChar = rf.getc();

    if (fnode.rfBufferChar != '\r') {

        fnode.rfBuffer[fnode.rfBufferCounter] = fnode.rfBufferChar;
        fnode.rfBufferCounter++;

    } else if (fnode.rfBufferChar == '\r') {

        rf.attach(NULL, Serial::RxIrq);
        fnode.rfBufferCounter = 0;
        fnode.rfInterruptComplete = true;
    }
}

void master_rx_isr()
{
    fnode.masterBufferChar = master.getc();

    if (fnode.masterBufferChar != '\r') {

        fnode.masterRxBuffer[fnode.masterBufferCounter] = fnode.masterBufferChar;
        fnode.masterBufferCounter++;

    } else if (fnode.masterBufferChar == '\r') {

        master.attach(NULL, Serial::RxIrq);
        fnode.masterBufferCounter = 0;
        fnode.masterInterruptComplete = true;
    }
}

// Sayaç pals ISR
void watermeter_isr()
{
    fnode.pulse ++;
    fnode.pulseTransmit ++;
    fnode.pulsePressureCheck ++;
}

// Yıkama fazı değişim ISR
void flush_phase_isr()
{
    fnode.flush_isr = true;
}

// Basınç kontrol ISR
void pressure_check_isr()
{
    fnode.checkPressure = true;
}

void periodic_flush_isr()
{
    fnode.periodicFlushCounter ++;
}

void min_flush_interval_isr()
{
    fnode.minFlushCounter ++;
}

void rt_data_transmit_isr()
{
    fnode.transmit_rtData = true;
    fnode.rtCounter ++;
}
#endif