#ifndef _DEFINE_H_
#define _DEFINE_H_
/*
    ****************************************************************************
    ****************************************************************************
    ** DEVINT BİLİŞİM YAZILIM DONANIM TİC. LTD. ŞTİ. TARAFINDAN GELİŞTİRİLMİŞTİR
    ** İzmir / TÜRKİYE
    **
    ** (C) 2015
    ****************************************************************************
    ****************************************************************************
    *************************************************************** K A M B O **
*/

/*  FİLTRASYON MASTER PIN SET
    RF Tx..................................................................PA_11
    RF Rx..................................................................PA_12
    RF Aktif...............................................................PB_10

    EEPROM SDA..............................................................PB_9
    EEPROM SCL..............................................................PB_8

    DP Sensörü (0-3.3VDC)...................................................PC_2
    Basınç Sensörü (4-20mA).................................................PA_0
    Akış Sensörü............................................................PC_3
    Sayaç...................................................................PC_4
*/

// MASTER ID
#define     MASTER_ID                                                           0x00

// EEPROM Ayarları
#define     EEPROM_TYPE                                                         1       // 1: 1 bayt hafıza adreslemeli EEPROM, 2: 2 bayt hafıza adreslemeli EEPROM
#define     EEPROM_ADDRESS                                                      0xA0    // EEPROM device address
#define     IO_EXPANDER_ADDRESS                                                 0x40    // IO çoklayıcı adresi
#define     EEPROM_FREQUENCY                                                    100000  // EEPROM frekansı 100 KHz

// EEPROM Varsayılan Değerler
#define     SYSTEM_SETUP_DEFAULT                                                15      // Sistem el kitabına bakın
#define     AUTOSEND_STATUS_DEFAULT                                             1       // 0: Otomatik veri aktarımı kapalı, 1: Otomatik veri aktarımı açık
#define     IRRI_TRANSMIT_INTERVAL_DEFAULT                                      15      // Sulama sırasında veri gönderim sıklığı (Dakika)
#define     DRY_TRANSMIT_INTERVAL_DEFAULT                                       15      // Sulama dışında veri gönderim sıklığı, (Dakika)
#define     PMAX_DEFAULT                                                        10      // Basınç sensörü max. basınç değeri (Bar)
#define     PRESSURE_SENSOR_DEFAULT                                             1       // Basınç sensörü tipi: 0: 0-3.3V (HONEYWELL), 1: 4-20mA 
#define     WATERMETER_COEFF_DEFAULT                                            1000    // Sayaç katsayısı (litre/pals)
#define     DP_DEFAULT                                                          10      // Ters yıkamanın başlayacağı fark basınç (DP) değeri, bar (10/10 = 1)
#define     PRESSURE_CONTROL_FREQUENCY_DEFAULT                                  30      // Basınç kontrol sıklığı (Saniye)
#define     FLUSH_DURATION_DEFAULT                                              45      // 1 filtre yıkama süresi (Saniye)
#define     FLUSH_INTERVAL_DEFAULT                                              30      // 2 filtre yıkaması arası bekleme süresi (Saniye)
#define     FLOW_CONTROL_LATENCY_DEFAULT                                        20      // Akış kontrolü gecikme süresi (Saniye)
#define     FLUSH_ENABLE_DEFAULT                                                1       // 0: Ters yıkama kapalı, 1: Ters yıkama açık
#define     PR_SENSOR_POSITION_DEFAULT                                          0       // 0: Basınç sensörü filtre girişinde, 1: Basınç sensörü filtre çıkışında
#define     BACKFLUSH_STOP_DEFAULT                                              0       // 0: Ters yıkama sırasındaki herhangi bir hatada ters yıkama devam eder, 1: Ters yıkama sırasındaki herhangi bir hatada ters yıkama durur
#define     INLET_PRS_LOW_TRS_DEFAULT                                           20      // Giriş basıncı alarmı alt eşik set değeri 1 bar (10/10 = 1)
#define     INLET_PRS_HIGH_TRS_DEFAULT                                          60      // Giriş basıncı alarmı üst eşik set değeri 7 bar (70/10 = 7)
#define     ALARMS_ENABLE_DEFAULT                                               1       // 0: Alarmlar kapalı, 1: Alarmlar açık
#define     DP_HIGH_TRS_DEFAULT                                                 15      // DP üst sınır alarmı eşik değeri (Bar) (/10)
#define     INLET_PRS_SET_DEFAULT                                               10      // Sulamanın başladığının anlaşıldığı giriş basıncı değeri 0.2 bar (2/10 = 0.2)
#define     OUTLET_PRS_SET_FOR_DP_DEFAULT                                       20      // DP kontrolünün başlayacağı filtrasyon çıkış basıncı (Bar) (/10)
#define     PERIODIC_FLUSH_DEFAULT                                              10      // Periyodik yıkama aktif ve belirtilen dakikada devreye girer. Bu değer sıfır ise periyodik yıkama aktiflenmez. (saat)
#define     MIN_FLUSH_INTERVAL_DEFAULT                                          5       // DP'ye göre yıkamada iki yıkama arasındaki süre (DAKİKA). Bu değer sıfır ise DP'ye göre yıkama bittiğinde DP değeri düşmemişse hemen yeniden yıkama yapar.
#define     FILTER_NUMBER_DEFAULT                                               4       // Varsayılan filtre sayısı 4

// EEPROM Adresleri
#define     DEFAULT_CONFIG_ADDR                                                 0x00
#define     IRRI_STATUS_ADDR                                                    0x01
#define     SYSTEM_SETUP_ADDR                                                   0x02
#define     AUTOSEND_STATUS_ADDR                                                0x03
#define     IRRI_TRANSMIT_INTERVAL_ADDR                                         0x04
#define     DRY_TRANSMIT_INTERVAL_ADDR                                          0x05
#define     WATERMETER_COEFF_ADDR_1                                             0x06
#define     WATERMETER_COEFF_ADDR_2                                             0x07
#define     PMAX_ADDR                                                           0x08
#define     PRESSURE_SENSOR_ADDR                                                0X09
#define     DP_ADDR                                                             0x0A
#define     PRESSURE_CONTROL_FREQUENCY_ADDR                                     0x0B
#define     FLUSH_DURATION_ADDR                                                 0x0C
#define     FLUSH_INTERVAL_ADDR                                                 0x0D
#define     FLOW_CONTROL_LATENCY_ADDR                                           0x0E
#define     FLUSH_ENABLE_ADDR                                                   0x0F
#define     PR_SENSOR_POSITION_ADDR                                             0x10
#define     BACKFLUSH_STOP_ADDR                                                 0x11
#define     INLET_PRS_LOW_TRS_ADDR                                              0x12
#define     INLET_PRS_HIGH_TRS_ADDR                                             0x13
#define     ALARMS_ENABLE_ADDR                                                  0x14
#define     DP_HIGH_TRS_ADDR                                                    0x15
#define     INLET_PRS_SET_ADDR                                                  0x16
#define     OUTLET_PRS_SET_FOR_DP_ADDR                                          0x17
#define     PERIODIC_FLUSH_ADDR                                                 0x18
#define     MIN_FLUSH_INTERVAL_ADDR_1                                           0x19
#define     MIN_FLUSH_INTERVAL_ADDR_2                                           0x1A
#define     FILTER_NUMBER_ADDR                                                  0x1B

// RF Koordinatör Adresi
#define     COORD_ADDR_1                                                        255     // WSN koordinatör adresi 1. baytı (0xFF)
#define     COORD_ADDR_2                                                        255     // WSN koordinatör adresi 2. baytı (0xFF)

// RF USART
#define     TX_RF                                                               PA_11   // RF Module Tx Pin (Serial6)
#define     RX_RF                                                               PA_12   // RF Module Rx Pin (Serial6)
#define     RF_ACTIVE                                                           PB_10   // RF Reset Pin (3.3v verilirse RF aktif kalır)
#define     BAUD_SERIAL_RF                                                      38400   // RF USART Baudrate
#define     CR                                                                  13      // "\r" ASCII kodu
#define     EQUAL                                                               61      // "=" ASCII kodu

// MASTER USART
#define     TX_MASTER                                                           PB_6
#define     RX_MASTER                                                           PB_7
#define     BAUD_MASTER                                                         38400
#define     CR                                                                  13      // "\r" ASCII kodu

// GPIO
#define     WATERMETER_PIN                                                      PC_4    // IN1 - Sayaç
#define     FLOW_PIN                                                            PC_3    // IN2 - Akış sensörü
#define     DP_PIN                                                              PC_2    // IN3 - Fark basınç sensörü
#define     PRESSURE_PIN                                                        PA_0    // IN4 - Basınç sensörü

// Diğer
#define     RMS_SAMPLING_NUMBER                                                 100     // Analog kanal okumaları için RMS örnekleme sayısı
#define     RT_DATA_TRANSMIT_INTERVAL                                           30      // Gerçek zamanlı veri 30 sn aralıkla gönderiliyor

// Alarmlar
#define     BACKFLUSH_DP_STARTED                255
#define     BAKCFLUSH_ENDED                     254

#define     DP_CONTROL_STARTED                  253

#define     IRRIGATION_STARTED                  252
#define     IRRIGATION_ENDED                    251

#define     INLET_LOW_PRESSURE                  250
#define     INLET_NORMAL_PRESSURE               249
#define     INLET_HIGH_PRESSURE                 248

#define     FILTER_FLUSH_STARTED                1
#define     FILTER_FLUSH_ENDED                  2

#define     NO_FLOW_DURING_FLUSH                3
#define     FLOW_DURING_FLUSH                   4

#define     BACKFLUSH_MANUAL_STARTED            247
#define     ALREADY_FLUSHING                    246
#define     NO_IRRIGATION_FOR_FLUSHING          245
#define     FLUSH_DISABLED                      244
#define     BACKFLUSH_PERIODIC_STARTED          243

enum node_commands {

    FENABLE = 1,
    FDISABLE,
    FSETSYS,
    FSETDEF,
    FGETCFG,
    FREAD,
    FSTART,
    FSTOP,
    FTEST,
    FRESET,
    FCLEAR,
    FFIX,
    FGETSTATUS,
    FGETFSTATUS,
    FLUSHNOW,
    SELTESTON,
    SELTESTOFF,
    FFGETSTAT
};

enum solenoid_commands {

    CLOSE_SOLENOID = 0x00,
    OPEN_SOLENOID = 0x01,
    TEST_OPEN_SOLENOID = 0x02,
    TEST_CLOSE_SOLENOID = 0x03

};

enum success_state {

    _ERROR_ = 0x00,
    _OK_ = 0x01

};

enum filter_solenoid_id {

    FILTER_MAIN_SOLENOID = 0x00,
    FILTER_1_SOLENOID = 0x01,
    FILTER_2_SOLENOID = 0x02,
    FILTER_3_SOLENOID = 0x03,
    FILTER_4_SOLENOID = 0x04

};

struct RTU {
    float dpPressure;
    float pressure;
    float inletPressure;
    float outletPressure;
    float flowrate;
    float flowrateTransmission;

    char temporaryBuffer[256];
    char dataBuffer[256];
    char rfBuffer[256];
    char str[24];
    char alarmBuffer[256];
    char edata;
    char edata2[2];
    char edata3[3];
    char value;
    char iodata[2];

    uint8_t systemSetup;
    uint8_t filterNumber;
    uint8_t dpSet;
    uint8_t flushDuration;
    uint8_t flushInterval;
    uint8_t pressureControlFrequency;
    uint8_t pMax;
    uint8_t pressureSensorType;
    uint8_t autosendStatus;
    uint8_t irriTransmitInterval;
    uint8_t dryTransmitInterval;
    uint8_t enableFlush;
    uint8_t filterByte_1;
    uint8_t filterByte_2;
    uint8_t flowControlLatency;
    uint8_t pressureSensorPosition;
    uint8_t pressureLowThreshold;
    uint8_t pressureHighThreshold;
    uint8_t dpThreshold;
    uint8_t inletPressureSet;
    uint8_t outletPressureSet;
    uint8_t alarm;
    uint8_t flushEnabled;
    uint8_t onErrorStop;
    uint8_t alarmsEnabled;

    uint16_t watermeterCoefficient;

    uint64_t WI;
    uint64_t WIC;
    float QI;

    uint64_t WD;
    uint64_t WDC;
    float QD;

    uint64_t rWI;
    uint64_t rWIC;
    float rQI;

    uint64_t rWD;
    uint64_t rWDC;
    float rQD;

    volatile uint64_t pulse;
    volatile uint64_t pulseTransmit;
    volatile uint64_t pulsePressureCheck;

    volatile bool transmitData;
    volatile bool rfInterruptComplete;
    bool flushStarted;
    volatile bool checkPressure;

    volatile uint8_t rfBufferCounter;
    volatile uint8_t flushPhase;

    volatile char rfBufferChar;

    bool irrigation;
    bool autosend;
    bool flushing;
    bool flowControl;
    bool errorOccured;
    bool pressureLowError;
    bool pressureNormalError;
    bool pressureHighError;
    bool dpControlStarted;
    bool checkDp;

    bool periodicFlushEnabled;
    uint8_t periodicFlushInterval;
    volatile uint16_t periodicFlushCounter;

    uint16_t minFlushInterval;
    volatile uint16_t minFlushCounter;
    bool isMinTimePassed;
    bool minFlushEnabled;

    volatile bool transmit_rtData;
    volatile uint8_t rtCounter;

    volatile uint64_t   rtPulseFirst;
    bool rtActive;

    uint8_t testFilterNo;

    uint16_t lastFlushPhase;

    volatile char masterBufferChar;
    char masterRxBuffer[2];
    char masterTxBuffer[5];
    volatile uint8_t masterBufferCounter;
    volatile bool masterInterruptComplete;

    uint16_t globalFlushPhase;
    uint8_t currentFlushPhase;
    uint8_t currentFlushingFilter;
    uint8_t currentWorkingSlave;
    uint16_t globalFlushingFilter;

    uint8_t testid;

    volatile bool flush_isr;

    uint8_t periodicFirstStartCounter;

    uint8_t totalSlaveNumber;


    RTU() {

        pulse = 0;
        pulseTransmit = 0;
        pulsePressureCheck = 0;

        rfBufferCounter = 0;
        alarm = 0;
        flushPhase = 0;
        pressureSensorPosition = 0;
        onErrorStop = 0;

        filterByte_1 = 255;
        filterByte_2 = 255;
        alarmsEnabled = 1;

        transmitData = false;
        rfInterruptComplete = false;
        irrigation = false;
        autosend = false;
        flushStarted = false;
        checkPressure = false;
        flushing = false;
        flowControl = false;
        errorOccured = false;
        pressureLowError = false;
        pressureNormalError = false;
        pressureHighError = false;
        dpControlStarted = false;
        checkDp = true;

        WI = 0;
        WIC = 0;
        QI = 0.0;

        WD = 0;
        WDC = 0;
        QD = 0.0;

        rWI = 0;
        rWIC = 0;
        rQI = 0.0;

        rWD = 0;
        rWDC = 0;
        rQD = 0.0;

        periodicFlushEnabled = false;
        periodicFlushInterval = 0;
        periodicFlushCounter = 0;

        minFlushInterval = 0;
        minFlushCounter = 0;
        isMinTimePassed = true;
        minFlushEnabled = false;

        transmit_rtData = false;
        rtCounter = 0;

        rtPulseFirst = 0;
        rtActive = false;

        masterBufferCounter = 0;
        masterInterruptComplete = false;

        flush_isr = false;

        periodicFirstStartCounter = 0;
    }
} fnode;

// Global değişkenler
uint8_t c1 = 0;
uint8_t c2 = 0;
uint8_t c3 = 0;
uint8_t c4 = 0;
uint8_t c5_a = 0;
uint8_t c5_b = 0;
uint16_t c5 = 0;
uint8_t c6 = 0;
uint8_t c7 = 0;
uint8_t c8 = 0;
uint8_t c9 = 0;
uint8_t c10 = 0;
uint8_t c11 = 0;
uint8_t c12 = 0;
uint8_t c13 = 0;
uint8_t c14 = 0;
uint8_t c15 = 0;
uint8_t c16 = 0;
uint8_t c17 = 0;
uint8_t c18 = 0;
uint8_t c19 = 0;
uint8_t c20 = 0;
uint8_t c21 = 0;
uint8_t c22 = 0;
uint8_t c23_a = 0;
uint8_t c23_b = 0;
uint16_t c23 = 0;
uint8_t c24 = 0;
uint8_t irriTrsIntOld = 0;
uint8_t dryTrsIntOld = 0;

float rmsStore[RMS_SAMPLING_NUMBER];
float totalSampling = 0.0;
float tempValue = 0.0;
float tp = 0.0;
float tdp = 0.0;
float tdpResult = 0.0;

// JSON
const char* jsonHeader[9] = {"PRIN:", "PROUT:", "DP:", "WI:", "WIC:", "QI:", "WD:", "WDC:", "QD:"};
const char* json[2] = {"{F:{", "}}"};
const char* jsonAlarm[15] = {"{ALR:\"FALR\"", "ALRCODE:", "APRSIN:", "ADP:", "AIRR:", "AFLUSH:", "AF11:", "AF12:", "AF21:", "AF22:", "AF31:", "AF32:", "AF41:", "AF42:", "}"};

// Komutlar
const char* fenable_command = "FENABLE";
const char* fdisable_command = "FDISABLE";
const char* fsetsys_command = "FSETSYS";
const char* fgetcfg_command = "FGETCFG";
const char* fread_command   = "FREAD";
const char* fstart_command  = "FSTART";
const char* fstop_command   = "FSTOP";
const char* ftest_command   = "FTEST";
const char* freset_command  = "FRESET";
const char* fclear_command  = "FCLEAR";
const char* ffix_command    = "FFIX";
const char* fgetstatus_command = "FGETSTATUS";
const char* fgetfstatus_command = "FGETFSTATUS";
const char* fflushnow_command = "FLUSHNOW";
const char* frton_command = "FRTON";
const char* frtoff_command = "FRTOFF";
const char* getfrtstatus_command = "GETFRTSTATUS";
const char* selteston_command = "SELTESTON";
const char* seltestoff_command = "SELTESTOFF";
const char* ffgetstat_command = "FFGETSTAT";

// EEPROM I2C
I2C i2c(I2C_SDA, I2C_SCL);

// DP Sensörü
AnalogIn dpSensor = DP_PIN;

// Basınç sensörü
AnalogIn pressureSensor = PRESSURE_PIN;

// Akış sensörü
DigitalIn flowSensor(FLOW_PIN, PullDown);

// RF Reset Pin
DigitalOut rfPower(RF_ACTIVE, 0);

// Sayaç & Sayaç ISR
DigitalIn watermeterPin(WATERMETER_PIN, PullDown);
InterruptIn watermeterInterrupt(WATERMETER_PIN);

// RF USART
RawSerial rf(TX_RF, RX_RF);
RawSerial master(TX_MASTER, RX_MASTER);

// Zamanlayıcılar
Timeout flushTimer;
Timer timer;
Ticker pressureCheckTicker;
Ticker dataTransmitTicker;
Ticker periodicFlushTicker;
Ticker minFlushTicker;
Ticker rtDataTransmitTicker;
#endif