#include "mbed.h"
 
#ifndef PID_H
#define PID_H
 
#define PID_SCALE   668        // 2*334 

class PID
{
    public:
    
    PID(float Kc, float Ki, float Kd, float interval);
    
    void ReadCurrentValue(int CurrentValue); // current Encoder Value
    void SetTargetValue(int targetValue);    // set Target Value
//    float Performance(void);                   // drive Motor ( return 0~1.0)
    
    float Performance_Speed(void);
    float Performance_Location(void);
    
    void Reset(void);
    void ResetError(void);
 
    float getP();
    void setP(float);
    float getI();
    void setI(float);
    float getD();
    void setD(float);    
    
    float ReadCurrentVelocity(void);
    
    private:
    
    float Kp_;
    float Ki_;
    float Kd_;
    float interval_;
    
    float err_;
    float accErr_;
    
    int CV_;
    int TV_;
    int prevCV_;
    
    float controllerOutput_;
    
    // speed control
    float prevVelocity_;
 
//  location control
    float ScaledCV_;
    float ScaledTV_;
    float ScaledPrevCV_;
    
    float Scale_;
};
 
 
#endif /* PID_H */
 