#include "mbed.h"
#define Debug

Serial      pc(USBTX, USBRX);

AnalogIn    LeftRight(PA_1);
AnalogIn    FrontBack(PA_0);


PwmOut      Wheel_L(PA_3);
PwmOut      Wheel_R(PA_4);
DigitalOut  Reverse_L(PB_5);
DigitalOut  Reverse_R(PB_4);
DigitalOut  re_L(PA_5);
DigitalOut  re_R(PA_6);

void turn()
{
        re_R = 0;
        re_L = 0;
        
        wait(0.1);
        
        re_R = 1;
        re_L = 1;
 
}

int main() 
{
    pc.baud(115200);
    
    Wheel_L.period(0.0001);
    Wheel_R.period(0.0001);
        
    
    while(1) 
    {   
    
            
        float a = 10*LeftRight.read();
        float b = 10*FrontBack.read();
        
        
        
        if(a>4 && a<8)
        {
                if(b>5) // Front
                {   
                    
    
                    Reverse_R = 1;
                    Reverse_L = 1;
                    
                    Wheel_L=0.41f;
                    Wheel_R=0.41f;
                    
                    wait(0.3);
                    
                    turn();
                    turn();
                    
                    
                }
                else if(b<2) // back
                {
                    
                    Reverse_R = 0;
                    Reverse_L = 0;
                                 
                    Wheel_L=0.41f;
                    Wheel_R=0.41f;
                    
                    wait(0.3);
                    
                    turn();
                    turn();
      

                
                }
        }
        
        else if(a>8) // left
        {
            
                Reverse_R = 1;
                Reverse_L = 0;
                     
                Wheel_L=0.4f;
                Wheel_R=0.43f;
                
                wait(0.3);
                    
                turn();
                


        }
                
        else if(a<4) // Right
        {

                Reverse_R = 0;
                Reverse_L = 1;
                
                Wheel_L=0.43f;
                Wheel_R=0.4f;
                
                wait(0.3);
                    
                turn();
        }
        
        else
        
        {
            Wheel_L=0;
            Wheel_R=0;
            
        }
        
        int c= re_L;
        int d= re_R;
        pc.printf("%1.3f,%1.3f ,%d, %d \n", a, b, c, d);
        wait(0.1);

        
    }
}
