#include "mbed.h"
#include "QEI.h"
#include "PololuLedStrip.h"


PololuLedStrip      led7(PB_0);
PololuLedStrip      led6(PA_12);
PololuLedStrip      led5(PB_6);
PololuLedStrip      led4(PB_1);
PololuLedStrip      led3(PA_8);
PololuLedStrip      led2(PA_11);
PololuLedStrip      led1(PA_3);
PololuLedStrip      led0(PA_4);

#define LED_COUNT 16

rgb_color colors0[LED_COUNT];
rgb_color colors1[LED_COUNT];
rgb_color colors2[LED_COUNT];
rgb_color colors3[LED_COUNT];
rgb_color colors4[LED_COUNT];
rgb_color colors5[LED_COUNT];
rgb_color colors6[LED_COUNT];
rgb_color colors7[LED_COUNT];

Ticker      led;

extern              QEI re;
extern int R;
extern int G;
extern int B;
extern              Serial bt;
extern int dayLed;

void LedOn1()
{
        
        int pulse = re.getPulses();  
        int d = pulse/200;
        
        if(48>=d)
        {
            
            uint8_t r[8];
            uint8_t g[8];
            uint8_t b[8];   
            
            for (int i=0 ; i<8 ; i++)
            {
                int n = (i+1); 
                int moveL_r = ((R/6)*(d-1*n*6))+R;
                int moveL_g = ((G/6)*(d-1*n*6))+G;
                int moveL_b = ((B/6)*(d-1*n*6))+B;
                
                moveL_r = (0 >= moveL_r) ? 0: moveL_r;
                moveL_g = (0 >= moveL_g) ? 0: moveL_g;
                moveL_b = (0 >= moveL_b) ? 0: moveL_b;
                
                moveL_r = (R <= moveL_r) ? R: moveL_r;
                moveL_g = (G <= moveL_g) ? G: moveL_g;
                moveL_b = (B <= moveL_b) ? B: moveL_b;
                
                
                r[i] = moveL_r;
                g[i] = moveL_g;
                b[i] = moveL_b;
                
            } 
            
            
        
            for(int i=0; i<16; i++)
            {
                colors0[i] = (rgb_color){ r[0], g[0], b[0] };
                colors1[i] = (rgb_color){ r[1], g[1], b[1] };
                colors2[i] = (rgb_color){ r[2], g[2], b[2] };
                colors3[i] = (rgb_color){ r[3], g[3], b[3] };
                colors4[i] = (rgb_color){ r[4], g[4], b[4] };
                colors5[i] = (rgb_color){ r[5], g[5], b[5] };
                colors6[i] = (rgb_color){ r[6], g[6], b[6] };
                colors7[i] = (rgb_color){ r[7], g[7], b[7] };
            }
            
            
            led0.write(colors0, LED_COUNT);
            led1.write(colors1, LED_COUNT);
            led2.write(colors2, LED_COUNT);
            led3.write(colors3, LED_COUNT);
            led4.write(colors4, LED_COUNT);
            led5.write(colors5, LED_COUNT);
            led6.write(colors6, LED_COUNT);
            led7.write(colors7, LED_COUNT);
            
        }
        
        else if(52<=d)
        {
            uint8_t r[8];
            uint8_t g[8];
            uint8_t b[8];
                                    
            for (int i=0 ; i<8 ; i++)
            {
                int moveR_r = -1*(R/6)*(d-1*(52+(i+1)*6))+R;
                int moveR_g = -1*(G/6)*(d-1*(52+(i+1)*6))+G;
                int moveR_b = -1*(B/6)*(d-1*(52+(i+1)*6))+B;
                                
                
                moveR_r = (0 >= moveR_r) ? 0: moveR_r;
                moveR_g = (0 >= moveR_g) ? 0: moveR_g;
                moveR_b = (0 >= moveR_b) ? 0: moveR_b;
                
                moveR_r = (R <= moveR_r) ? R: moveR_r;
                moveR_g = (G <= moveR_g) ? G: moveR_g;
                moveR_b = (B <= moveR_b) ? B: moveR_b;
                
                
                r[i] = moveR_r;
                g[i] = moveR_g;
                b[i] = moveR_b;
            }

            
        
            for(int i=0; i<16; i++)
            {
                colors0[i] = (rgb_color){ r[0], g[0], b[0] };
                colors1[i] = (rgb_color){ r[1], g[1], b[1] };
                colors2[i] = (rgb_color){ r[2], g[2], b[2] };
                colors3[i] = (rgb_color){ r[3], g[3], b[3] };
                colors4[i] = (rgb_color){ r[4], g[4], b[4] };
                colors5[i] = (rgb_color){ r[5], g[5], b[5] };
                colors6[i] = (rgb_color){ r[6], g[6], b[6] };
                colors7[i] = (rgb_color){ r[7], g[7], b[7] };
            }
            
            
            led0.write(colors0, LED_COUNT);
            led1.write(colors1, LED_COUNT);
            led2.write(colors2, LED_COUNT);
            led3.write(colors3, LED_COUNT);
            led4.write(colors4, LED_COUNT);
            led5.write(colors5, LED_COUNT);
            led6.write(colors6, LED_COUNT);
            led7.write(colors7, LED_COUNT);
            
        }
        
        else
        {
            
            for(int i=0; i<16; i++)
            {
                colors0[i] = (rgb_color){ R, G, B };
                colors1[i] = (rgb_color){ R, G, B };
                colors2[i] = (rgb_color){ R, G, B };
                colors3[i] = (rgb_color){ R, G, B };
                colors4[i] = (rgb_color){ R, G, B };
                colors5[i] = (rgb_color){ R, G, B };
                colors6[i] = (rgb_color){ R, G, B };
                colors7[i] = (rgb_color){ R, G, B };
            }
            
            
            led0.write(colors0, LED_COUNT);
            led1.write(colors1, LED_COUNT);
            led2.write(colors2, LED_COUNT);
            led3.write(colors3, LED_COUNT);
            led4.write(colors4, LED_COUNT);
            led5.write(colors5, LED_COUNT);
            led6.write(colors6, LED_COUNT);
            led7.write(colors7, LED_COUNT);
        }
    
}


void LedOn2()
{
    
        int pulse = re.getPulses();  
        int p = pulse/200;
        uint8_t k[8];
        int n = 8;
        int d = 6;
        double bi= 0.02f;
        
        uint8_t r[8];
        uint8_t g[8];
        uint8_t b[8];
        
        for (int i=0 ; i<8 ; i++)
        {
            k[i] = ((n-i)*d)/log((1/bi)+1);
        }
        
        
        if(48>=p)
        {


            for (int i=0 ; i<8 ; i++)
            {

                int moveL_r = R*bi*(10^((p-1*i*d)/k[i])-1);
                int moveL_g = G*bi*(10^((p-1*i*d)/k[i])-1);
                int moveL_b = B*bi*(10^((p-1*i*d)/k[i])-1);;
                 
                moveL_r = (0 >= moveL_r) ? 0: moveL_r;
                moveL_g = (0 >= moveL_g) ? 0: moveL_g;
                moveL_b = (0 >= moveL_b) ? 0: moveL_b;
                
                moveL_r = (R <= moveL_r) ? R: moveL_r;
                moveL_g = (G <= moveL_g) ? G: moveL_g;
                moveL_b = (B <= moveL_b) ? B: moveL_b;
                 
                r[i] = moveL_r;
                g[i] = moveL_g;
                b[i] = moveL_b;
    
            } 
            
        
            for(int i=0; i<16; i++)
            {
                colors0[i] = (rgb_color){ r[0], g[0], b[0] };
                colors1[i] = (rgb_color){ r[1], g[1], b[1] };
                colors2[i] = (rgb_color){ r[2], g[2], b[2] };
                colors3[i] = (rgb_color){ r[3], g[3], b[3] };
                colors4[i] = (rgb_color){ r[4], g[4], b[4] };
                colors5[i] = (rgb_color){ r[5], g[5], b[5] };
                colors6[i] = (rgb_color){ r[6], g[6], b[6] };
                colors7[i] = (rgb_color){ r[7], g[7], b[7] };
            }
            
            
            led0.write(colors0, LED_COUNT);
            led1.write(colors1, LED_COUNT);
            led2.write(colors2, LED_COUNT);
            led3.write(colors3, LED_COUNT);
            led4.write(colors4, LED_COUNT);
            led5.write(colors5, LED_COUNT);
            led6.write(colors6, LED_COUNT);
            led7.write(colors7, LED_COUNT);
            
 
          
        }
        
        else if(49<=p)
        {

                                    
            for (int i=0 ; i<8 ; i++)
            {

                int moveR_r = R*bi*(10^((-1*p+(n+1+i)*d)/k[n-1-i])-1);
                int moveR_g = G*bi*(10^((-1*p+(n+1+i)*d)/k[n-1-i])-1);
                int moveR_b = B*bi*(10^((-1*p+(n+1+i)*d)/k[n-1-i])-1);
                
                moveR_r = (0 >= moveR_r) ? 0: moveR_r;
                moveR_g = (0 >= moveR_g) ? 0: moveR_g;
                moveR_b = (0 >= moveR_b) ? 0: moveR_b;
                
                moveR_r = (R <= moveR_r) ? R: moveR_r;
                moveR_g = (G <= moveR_g) ? G: moveR_g;
                moveR_b = (B <= moveR_b) ? B: moveR_b;
                
                r[i] = moveR_r;
                g[i] = moveR_g;
                b[i] = moveR_b;
                                
            }

            
        
            for(int i=0; i<16; i++)
            {
                colors0[i] = (rgb_color){ r[0], g[0], b[0] };
                colors1[i] = (rgb_color){ r[1], g[1], b[1] };
                colors2[i] = (rgb_color){ r[2], g[2], b[2] };
                colors3[i] = (rgb_color){ r[3], g[3], b[3] };
                colors4[i] = (rgb_color){ r[4], g[4], b[4] };
                colors5[i] = (rgb_color){ r[5], g[5], b[5] };
                colors6[i] = (rgb_color){ r[6], g[6], b[6] };
                colors7[i] = (rgb_color){ r[7], g[7], b[7] };
            }
            
            
            led0.write(colors0, LED_COUNT);
            led1.write(colors1, LED_COUNT);
            led2.write(colors2, LED_COUNT);
            led3.write(colors3, LED_COUNT);
            led4.write(colors4, LED_COUNT);
            led5.write(colors5, LED_COUNT);
            led6.write(colors6, LED_COUNT);
            led7.write(colors7, LED_COUNT);
            
        }
        
//        else
//        {
//            
//            for(int i=0; i<16; i++)
//            {
//                colors0[i] = (rgb_color){ R, G, B };
//                colors1[i] = (rgb_color){ R, G, B };
//                colors2[i] = (rgb_color){ R, G, B };
//                colors3[i] = (rgb_color){ R, G, B };
//                colors4[i] = (rgb_color){ R, G, B };
//                colors5[i] = (rgb_color){ R, G, B };
//                colors6[i] = (rgb_color){ R, G, B };
//                colors7[i] = (rgb_color){ R, G, B };
//            }
//            
//            
//            led0.write(colors0, LED_COUNT);
//            led1.write(colors1, LED_COUNT);
//            led2.write(colors2, LED_COUNT);
//            led3.write(colors3, LED_COUNT);
//            led4.write(colors4, LED_COUNT);
//            led5.write(colors5, LED_COUNT);
//            led6.write(colors6, LED_COUNT);
//            led7.write(colors7, LED_COUNT);
//        }

}

void LedOn3()
{
    
        int pulse = re.getPulses();  
        int d = pulse/200;
        
        
        if(48>=d)
        {
            
            uint8_t r[8];
            uint8_t g[8];
            uint8_t b[8];   

            
            for (int i=0 ; i<8 ; i++)
            { 
                int moveL_r = ((R/(48-6*(i)))+1)*(d-48)+R;
                int moveL_g = ((G/(48-6*(i)))+1)*(d-48)+G;
                int moveL_b = ((B/(48-6*(i)))+1)*(d-48)+B;
                
                r[i] = (0 >= moveL_r) ? 0: moveL_r;
                g[i] = (0 >= moveL_g) ? 0: moveL_g;
                b[i] = (0 >= moveL_b) ? 0: moveL_b;
            } 
            
            
        
            for(int i=0; i<16; i++)
            {
                colors0[i] = (rgb_color){ r[0], g[0], b[0] };
                colors1[i] = (rgb_color){ r[1], g[1], b[1] };
                colors2[i] = (rgb_color){ r[2], g[2], b[2] };
                colors3[i] = (rgb_color){ r[3], g[3], b[3] };
                colors4[i] = (rgb_color){ r[4], g[4], b[4] };
                colors5[i] = (rgb_color){ r[5], g[5], b[5] };
                colors6[i] = (rgb_color){ r[6], g[6], b[6] };
                colors7[i] = (rgb_color){ r[7], g[7], b[7] };
            }
            
            
            led0.write(colors0, LED_COUNT);
            led1.write(colors1, LED_COUNT);
            led2.write(colors2, LED_COUNT);
            led3.write(colors3, LED_COUNT);
            led4.write(colors4, LED_COUNT);
            led5.write(colors5, LED_COUNT);
            led6.write(colors6, LED_COUNT);
            led7.write(colors7, LED_COUNT);
            
        }
        
        else if(52<=d)
        {
            uint8_t r[8];
            uint8_t g[8];
            uint8_t b[8];
                                    
            for (int i=0 ; i<8 ; i++)
            {
                int moveR_r = ((-1*R/(6+6*(i)))-1)*(d-52)+R;
                int moveR_g = ((-1*G/(6+6*(i)))-1)*(d-52)+G;
                int moveR_b = ((-1*B/(6+6*(i)))-1)*(d-52)+B;
                                
                r[i] = (0 >= moveR_r) ? 0:moveR_r ;
                g[i] = (0 >= moveR_g) ? 0:moveR_g ;
                b[i] = (0 >= moveR_b) ? 0:moveR_b ;
            }

            
        
            for(int i=0; i<16; i++)
            {
                colors0[i] = (rgb_color){ r[0], g[0], b[0] };
                colors1[i] = (rgb_color){ r[1], g[1], b[1] };
                colors2[i] = (rgb_color){ r[2], g[2], b[2] };
                colors3[i] = (rgb_color){ r[3], g[3], b[3] };
                colors4[i] = (rgb_color){ r[4], g[4], b[4] };
                colors5[i] = (rgb_color){ r[5], g[5], b[5] };
                colors6[i] = (rgb_color){ r[6], g[6], b[6] };
                colors7[i] = (rgb_color){ r[7], g[7], b[7] };
            }
            
            
            led0.write(colors0, LED_COUNT);
            led1.write(colors1, LED_COUNT);
            led2.write(colors2, LED_COUNT);
            led3.write(colors3, LED_COUNT);
            led4.write(colors4, LED_COUNT);
            led5.write(colors5, LED_COUNT);
            led6.write(colors6, LED_COUNT);
            led7.write(colors7, LED_COUNT);
            
        }
        
        else
        {
            
            for(int i=0; i<16; i++)
            {
                colors0[i] = (rgb_color){ R, G, B };
                colors1[i] = (rgb_color){ R, G, B };
                colors2[i] = (rgb_color){ R, G, B };
                colors3[i] = (rgb_color){ R, G, B };
                colors4[i] = (rgb_color){ R, G, B };
                colors5[i] = (rgb_color){ R, G, B };
                colors6[i] = (rgb_color){ R, G, B };
                colors7[i] = (rgb_color){ R, G, B };
            }
            
            
            led0.write(colors0, LED_COUNT);
            led1.write(colors1, LED_COUNT);
            led2.write(colors2, LED_COUNT);
            led3.write(colors3, LED_COUNT);
            led4.write(colors4, LED_COUNT);
            led5.write(colors5, LED_COUNT);
            led6.write(colors6, LED_COUNT);
            led7.write(colors7, LED_COUNT);
        }
    
}

void MoonPhase()
{
         
        int d = dayLed;;
        
        if(48>=d)
        {
            
            uint8_t r[8];
            uint8_t g[8];
            uint8_t b[8];   
            
            for (int i=0 ; i<8 ; i++)
            {
                int n = (i+1); 
                int moveL_r = ((R/6)*(d-1*n*6))+R;
                int moveL_g = ((G/6)*(d-1*n*6))+G;
                int moveL_b = ((B/6)*(d-1*n*6))+B;
                
                moveL_r = (0 >= moveL_r) ? 0: moveL_r;
                moveL_g = (0 >= moveL_g) ? 0: moveL_g;
                moveL_b = (0 >= moveL_b) ? 0: moveL_b;
                
                moveL_r = (R <= moveL_r) ? R: moveL_r;
                moveL_g = (G <= moveL_g) ? G: moveL_g;
                moveL_b = (B <= moveL_b) ? B: moveL_b;
                
                
                r[i] = moveL_r;
                g[i] = moveL_g;
                b[i] = moveL_b;
                
            } 
            
            
        
            for(int i=0; i<16; i++)
            {
                colors0[i] = (rgb_color){ r[0], g[0], b[0] };
                colors1[i] = (rgb_color){ r[1], g[1], b[1] };
                colors2[i] = (rgb_color){ r[2], g[2], b[2] };
                colors3[i] = (rgb_color){ r[3], g[3], b[3] };
                colors4[i] = (rgb_color){ r[4], g[4], b[4] };
                colors5[i] = (rgb_color){ r[5], g[5], b[5] };
                colors6[i] = (rgb_color){ r[6], g[6], b[6] };
                colors7[i] = (rgb_color){ r[7], g[7], b[7] };
            }
            
            
            led0.write(colors0, LED_COUNT);
            led1.write(colors1, LED_COUNT);
            led2.write(colors2, LED_COUNT);
            led3.write(colors3, LED_COUNT);
            led4.write(colors4, LED_COUNT);
            led5.write(colors5, LED_COUNT);
            led6.write(colors6, LED_COUNT);
            led7.write(colors7, LED_COUNT);
            
        }
        
        else if(52<=d)
        {
            uint8_t r[8];
            uint8_t g[8];
            uint8_t b[8];
                                    
            for (int i=0 ; i<8 ; i++)
            {
                int moveR_r = -1*(R/6)*(d-1*(52+(i+1)*6))+R;
                int moveR_g = -1*(G/6)*(d-1*(52+(i+1)*6))+G;
                int moveR_b = -1*(B/6)*(d-1*(52+(i+1)*6))+B;
                                
                
                moveR_r = (0 >= moveR_r) ? 0: moveR_r;
                moveR_g = (0 >= moveR_g) ? 0: moveR_g;
                moveR_b = (0 >= moveR_b) ? 0: moveR_b;
                
                moveR_r = (R <= moveR_r) ? R: moveR_r;
                moveR_g = (G <= moveR_g) ? G: moveR_g;
                moveR_b = (B <= moveR_b) ? B: moveR_b;
                
                
                r[i] = moveR_r;
                g[i] = moveR_g;
                b[i] = moveR_b;
            }

            
        
            for(int i=0; i<16; i++)
            {
                colors0[i] = (rgb_color){ r[0], g[0], b[0] };
                colors1[i] = (rgb_color){ r[1], g[1], b[1] };
                colors2[i] = (rgb_color){ r[2], g[2], b[2] };
                colors3[i] = (rgb_color){ r[3], g[3], b[3] };
                colors4[i] = (rgb_color){ r[4], g[4], b[4] };
                colors5[i] = (rgb_color){ r[5], g[5], b[5] };
                colors6[i] = (rgb_color){ r[6], g[6], b[6] };
                colors7[i] = (rgb_color){ r[7], g[7], b[7] };
            }
            
            
            led0.write(colors0, LED_COUNT);
            led1.write(colors1, LED_COUNT);
            led2.write(colors2, LED_COUNT);
            led3.write(colors3, LED_COUNT);
            led4.write(colors4, LED_COUNT);
            led5.write(colors5, LED_COUNT);
            led6.write(colors6, LED_COUNT);
            led7.write(colors7, LED_COUNT);
            
        }
        
        else
        {
            
            for(int i=0; i<16; i++)
            {
                colors0[i] = (rgb_color){ R, G, B };
                colors1[i] = (rgb_color){ R, G, B };
                colors2[i] = (rgb_color){ R, G, B };
                colors3[i] = (rgb_color){ R, G, B };
                colors4[i] = (rgb_color){ R, G, B };
                colors5[i] = (rgb_color){ R, G, B };
                colors6[i] = (rgb_color){ R, G, B };
                colors7[i] = (rgb_color){ R, G, B };
            }
            
            
            led0.write(colors0, LED_COUNT);
            led1.write(colors1, LED_COUNT);
            led2.write(colors2, LED_COUNT);
            led3.write(colors3, LED_COUNT);
            led4.write(colors4, LED_COUNT);
            led5.write(colors5, LED_COUNT);
            led6.write(colors6, LED_COUNT);
            led7.write(colors7, LED_COUNT);
        }
    
}


void ModeSelect(int mode)
{
    
    switch(mode)
    {
        
        case 0 :
        
        led.detach();

        
        break;
        
        case 1 :
        led.detach();
        
        R = 119;
        G = 66;
        B = 255;
        
        led.attach(&LedOn1, 0.05);
        
        break;
        
        case 2 :

        led.detach();
        
        R = 119;
        G = 66;
        B = 255;
        
        led.attach(&LedOn2, 0.05);
        break;
        
        case 3 :
    
        led.detach();
        
        R = 119;
        G = 66;
        B = 255;
        
        led.attach(&LedOn3, 0.05);
        
        break;
        
        case 4 :
    
        led.detach();
        
        R = 119;
        G = 66;
        B = 255;
        
        led.attach(&MoonPhase, 0.05);
        
        break;
        
    }
    
}

