#ifndef GSMLIBRARY_H
#define GSMLIBRARY_H

#include "mbed.h"

#define TIME_CONST 1    //Specify length of each GSM tick (currently called twice every 2 seconds, so an average of every 1 second)
#define SECONDS_TIMEOUT 30
#define SMS_END_CHAR "\x1A"     //Character that must be appended to end of text message before it will be sent
#define SMS_ESCAPE_CHAR "\x1A"  //Character that can be appended to end of text message to abort sending it

enum gsm_states{GSM_INITIALIZE, 
                    GSM_CHECK_SIM,  //Send initial AT Command and Check SIM Card Status
                    GSM_JOIN,       //Join the wireless network
                    GSM_SERVER_IP,  //Get the IP Address for the server
                    GSM_CONNECT,    //Connect to the server via tcp on specified port
                    GSM_SEND,       //Send data to server via tcp 
                    GSM_WAIT        //State to wait between successive data sent to the server 
                };

//GSM state machine
void gsm_tick();
bool gsm_timeOut();
void gsm_printState();
void gsm_nextStateLogic();

//Initialize DMA data transfer, and UART3.
void gsm_initialize();

//returns 1 for ready to send again, 0 for busy.
bool gsm_ready();

//Have the GSM send data - L = long, S = short, hh/mm/ss for time, "lat ns" for latitute, "lon we" for longitude
void gsm_send_data(float L, float Lref, int hh, int mm, int ss, float lat, char ns,  float lon, char we);

//Brings state machine back to initialize state (notice this is a bit different than the initialize function)
//This will set flags to their initial values and prepare gsm to start anew.
void gsm_reset();

//For debugging: print registers related to DMA and UART setup
void print_registers();

#endif