#ifndef GSMQUEUE_H
#define GSMQUEUE_H

/* gsmqueue.h
 * Contains functions to read from the DMA buffer in a queue fashion
 */

//Memory block of char size alocated for DMA
#define BUFFER_LENGTH 2000
#define MAX_SMS_LENGTH 700    //Absolute SMS length max = 900 (let's do 700 to be safe)
#define QUEUETAIL (char*)DMA_TCD0_DADDR


//Public functions ------------------------------------------------------------------------------
//Initialize variables 
void queueInit();

//Send gsm a command
void sendCommand(char* sPtr);

//Return 1 if queue has data and the GSM is done transmitting its response
bool queueHasResponse();

//Find an occurrence of the given string in the buffer.
//If advanceQueueHead is true, advance queueHead just until a matching string is found.
bool findInQueue(char* str, bool advanceQueueHead);

//Parse through characters until first integer is found
int parseInt();

//Print queue elements
void printQueue();   //for debugging


//Internal functions ------------------------------------------------------------------------------
//Get the GSM DMA idle bit (if 1, indicates we aren't in the process of receiving a response)
bool getGSMIdleBit();

//Returns true if the character is numeric
bool isNumeric(char* qPos);

//Increment queue position by 1 (Note: this function is only used by gsmqueue.cpp)
char* incrementIndex(char* pointerToIncrement);

//Increment queue position by n (Note: this function is only used by gsmqueue.cpp)
char* incrementIndex(char* pointerToIncrement, int n);

//Get size of the queue from reference point of tail parameter
int queueSize(char* tail);

//Clear queue (Note: this function is only used by gsmqueue.cpp)
void flushQueue();

#endif