#pragma once
#include "mbed.h"
#include "math.h"
#include "MBed_Adafruit_GPS.h"
#include "SDFileSystem.h"
#include "QAM.h"
#include "param.h"
#include "GSMLibrary.h"
#include "stdlib.h"
#include "GPRSInterface.h"

DigitalOut led_red(LED_RED);
Serial pc(USBTX, USBRX);
Timer t;
bool run = 0;
bool fil = 0;

/**************************************************
 **          SD FILE SYSTEM                       **
 **************************************************/
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd");
FILE *fpLog;
FILE *fpData;
/**************************************************
 **          GPS                                 **
 **************************************************/
Serial * gps_Serial;

/**************************************************
 **          SENSOR INPUTS                       **
 **************************************************/
AnalogIn AnLong(A0);
AnalogIn AnRefLong(A2);
Ticker sample_tick;
bool takeSample = false;
void tick()
{
    takeSample = true;
}

/**************************************************
 **          SIN OUTPUT                          **
 **************************************************/
AnalogOut dac0(DAC0_OUT);
int sinRes = (int)1/(CARRIER_FREQ*TIME_CONST);
float sinWave[SIN_LENGTH] = {};
int sinIndex = 0;


/**************************************************
 **          QAM                                 **
 **************************************************/
float sLQ[SAMPLE_LENGTH] = {};
float sLI[SAMPLE_LENGTH] = {};
float sRefLQ[SAMPLE_LENGTH] = {};
float sRefLI[SAMPLE_LENGTH] = {};

float Iarray[SAMPLE_LENGTH] = {};
float Qarray[SAMPLE_LENGTH] = {};
int sampleIndex = 0;
float I = 0;
float Q = 0;
float lon = 0;
float lonRef = 0;

/*Global Variables*/
extern GPRSInterface eth;

/*End Global Variables*/
void buildIQ()
{
    for(int i = 0; i < SAMPLE_LENGTH; i++) {
        Iarray[i] = cos(2*PI*CARRIER_FREQ*i*TIME_CONST);
        Qarray[i] = -sin(2*PI*CARRIER_FREQ*i*TIME_CONST);
    }
}

void create_sinWave()
{
    int i = 0;
    for(i = 0; i < SIN_LENGTH; i++) {
        sinWave[i] = 0.25 * sin(2.0*PI*i/sinRes) + 0.75;
    }
}

int main ()
{   
    pc.printf("hello\r\n");
    //Initilialize the GSM
    //gsm_initialize();
    // GPS INITIALIZATION //////////////////////////////
    gps_Serial = new Serial(PTC4,PTC3); ////Serial gsm(D1,D0);
    Adafruit_GPS myGPS(gps_Serial);
    char c;
    myGPS.begin(9600);
    myGPS.sendCommand(PMTK_SET_NMEA_OUTPUT_RMCGGA);
    myGPS.sendCommand(PMTK_SET_NMEA_UPDATE_1HZ);
    myGPS.sendCommand(PGCMD_ANTENNA);
    ////////////////////////////////////////////////////

    buildIQ();
    create_sinWave();

    float filteredLong = 0;
    float filteredLongRef = 0;

    fpData = fopen("/sd/data.txt", "a");
    if (fpData != NULL) {
        fprintf(fpData, "--------------- DCS ------------------");
    }


    void gsm_initialize();

    sample_tick.attach(&tick, 0.0001);

    t.start();

    while(1) {

        if(takeSample) {

            dac0 = sinWave[sinIndex];

            lon = AnLong.read();
            lonRef = AnRefLong.read();

            I = Iarray[sampleIndex];
            Q = Qarray[sampleIndex];
            sLI[sampleIndex] = lon*I;
            sLQ[sampleIndex] = lon*Q;
            sRefLI[sampleIndex] = lonRef*I;
            sRefLQ[sampleIndex] = lonRef*Q;

            takeSample = false;

            sinIndex++;
            if((sinIndex+1) > SIN_LENGTH) {
                sinIndex = 0;
            }


            sampleIndex++;
            if(sampleIndex+1 > SAMPLE_LENGTH) {
                fil = 1;
            }


        }

        if(fil==1) {

            fil = 0;
            run = 1;

            sampleIndex = 0;

            gsm_tick();

            filteredLong = 15*QAM(sLI, sLQ);
            filteredLongRef = QAM(sRefLI, sRefLQ);

            gsm_tick();

        }
        c = myGPS.read();
        if ( myGPS.newNMEAreceived() ) {
            if ( !myGPS.parse(myGPS.lastNMEA()) ) {
                //continue;
            }
        }

        if(run) {
            led_red = !led_red;
            run = 0;

            pc.printf("%f, ", filteredLong);
            pc.printf("%f, ", filteredLongRef);
            pc.printf("%f\r\n", filteredLong/filteredLongRef);
            pc.printf("%02d:%02d:%02d \r\n", myGPS.hour-6, myGPS.minute, myGPS.seconds);

            if (myGPS.fix) pc.printf("%5.2f%c, %5.2f%c\r\n", myGPS.latitude, myGPS.lat, myGPS.longitude, myGPS.lon);
            else           pc.printf("No GPS fix\r\n");
            pc.printf("--------------------------------\r\n");

            fpData = fopen("/sd/data.txt", "a");
            if (fpData != NULL) {
                fprintf(fpData, "%f, ", filteredLong);
                fprintf(fpData, "%f\r\n", filteredLongRef);
                fprintf(fpData, "%02d:%02d:%02d\r\n", myGPS.hour-6, myGPS.minute, myGPS.seconds);
                if (myGPS.fix) fprintf(fpData, "%5.2f%c, %5.2f%c\r\n", myGPS.latitude, myGPS.lat, myGPS.longitude, myGPS.lon);
                fclose(fpData);
            }
            if(myGPS.fix)
                gsm_send_data(filteredLong, filteredLongRef, myGPS.hour-6, myGPS.minute, myGPS.seconds, myGPS.latitude, myGPS.lat, myGPS.longitude, myGPS.lon);
            else
                gsm_send_data(filteredLong, filteredLongRef,myGPS.hour-6, myGPS.minute, myGPS.seconds, 0, 0, 0, 0);
            
        }

    }
}