#include "mbed.h"
#include "math.h"
#include "param.h"


float LPF[FILTER_LENGTH] = {-0.0144708808511496,-0.000385188817745075,-0.000390533183235675,-0.000394742906792089,-0.000399769196519628,-0.000403738202294335,-0.000408404623158276,-0.000412113149650395,-0.000416462833527476,-0.000419815012719482,-0.000423797959228978,-0.000426739337854087,-0.000430334330303594,-0.000432832690421492,-0.000436010304838419,-0.000438015762483701,-0.000440725998487324,-0.000442176271462813,-0.000444366451120004,-0.000445200741523877,-0.000446824764367193,-0.000446985068265349,-0.000448006554506719,-0.000447442784206942,-0.000447849219199270,-0.000446533842477948,-0.000446356250904501,-0.000444298930233344,-0.000443635712144896,-0.000440904172137380,-0.000439959781942889,-0.000436697184341028,-0.000435806956375018,-0.000432172615546733,-0.000431753345765173,-0.000427687598858029,-0.000428156810812652,-0.000422747252741829,-0.000424187630414963,-0.000407818792155013,-0.000395501352613792,-0.000405744503950700,-0.000392851507058367,-0.000390382687328383,-0.000381121528334916,-0.000376496114768088,-0.000367538945283741,-0.000361525919288397,-0.000352310773450881,-0.000345231412211433,-0.000335566815920174,-0.000327541463775560,-0.000317294849082828,-0.000308353744912893,-0.000297429505735636,-0.000287581380689517,-0.000275914761004970,-0.000265156646491960,-0.000252692261710763,-0.000241008558077738,-0.000227700089453720,-0.000215083331568167,-0.000200913782464340,-0.000187389392522164,-0.000172384694451466,-0.000158020178787410,-0.000142244665767066,-0.000127136823721230,-0.000110658475023229,-9.48790548136458e-05,-7.76831002440304e-05,-6.11819123150781e-05,-4.30660620622803e-05,-2.56168041232741e-05,-6.17332989349961e-06,1.25088872664492e-05,3.37927012878936e-05,5.35608705831692e-05,7.59589602239430e-05,9.15368291316554e-05,0.000115204777102917,0.000138069211971015,0.000159190880367532,0.000182373449206352,0.000205067466595210,0.000228860953939147,0.000252562953392044,0.000277043582173064,0.000301679014228284,0.000326937646605074,0.000352496019331738,0.000378568482119590,0.000405024475185201,0.000431919761467725,0.000459260045317933,0.000486996257677674,0.000515223422553390,0.000543812348041683,0.000572911638300866,0.000602328160312027,0.000632248178590089,0.000662431004457176,0.000693100970238447,0.000723983335774392,0.000755351502448320,0.000786905176937580,0.000818981905467808,0.000851254211738706,0.000884129083715379,0.000917225959710777,0.000951002817600966,0.000984976999461651,0.00101962720509619,0.00105433282442391,0.00108958012424409,0.00112464418634772,0.00115993840154260,0.00119539198931307,0.00123186816927046,0.00127036077901721,0.00130541180260479,0.00134335225448012,0.00138072879053652,0.00141863315366209,0.00145663029979914,0.00149499706458300,0.00153361610136926,0.00157251046039164,0.00161168223712593,0.00165107252541929,0.00169074663426727,0.00173062458634377,0.00177079136483371,0.00181115593295544,0.00185179221443832,0.00189260160550475,0.00193364149890840,0.00197481806389987,0.00201618182472885,0.00205765641294420,0.00209929421544075,0.00214104214683175,0.00218295189552009,0.00222499505616725,0.00226720655336976,0.00230957893654704,0.00235209893435240,0.00239478098228574,0.00243752682581544,0.00248040445148945,0.00252320826984942,0.00256614456884563,0.00260887923650444,0.00265189493075013,0.00269464123994112,0.00273811141960323,0.00278127146884799,0.00282487273216248,0.00286725582554936,0.00291011668741703,0.00295400852337480,0.00299631315283477,0.00303968228399754,0.00308228214271367,0.00312544335611165,0.00316800503060222,0.00321092060767114,0.00325335212983191,0.00329604768194258,0.00333833065815270,0.00338080571964383,0.00342287984676659,0.00346506666392088,0.00350683252327144,0.00354864820837975,0.00359002966433764,0.00363143184222281,0.00367240631021559,0.00371339474804699,0.00375396921299398,0.00379455066286027,0.00383471907116473,0.00387486722320318,0.00391457835212350,0.00395421450957656,0.00399336963891983,0.00403239345178008,0.00407090689986944,0.00410927413031459,0.00414714356884360,0.00418491195887327,0.00422220071777701,0.00425944291055203,0.00429609837010503,0.00433271517977119,0.00436816038563848,0.00440392829477787,0.00443863216787577,0.00447419332340360,0.00450790720060468,0.00454199779778719,0.00457557942718267,0.00460866745561361,0.00464128935709596,0.00467348005622625,0.00470521813258529,0.00473655480891466,0.00476738158613443,0.00479778554290533,0.00482760230079293,0.00485697947442532,0.00488572614267468,0.00491404812783003,0.00494172982871532,0.00496901245787740,0.00499565014615655,0.00502189761027694,0.00504747871309519,0.00507265469059348,0.00509712658822537,0.00512116774916649,0.00514446385204792,0.00516731571406126,0.00518939504399896,0.00521104829385877,0.00523192156106234,0.00525241391733289,0.00527210766449571,0.00529145309701562,0.00530992168933153,0.00532803731039166,0.00534513592720032,0.00536190019920468,0.00537753105163574,0.00539305759593844,0.00540779717266560,0.00542178330942988,0.00543520553037524,0.00544764194637537,0.00546016823500395,0.00547122210264206,0.00548202730715275,0.00549201155081391,0.00550147471949458,0.00551019050180912,0.00551821896806359,0.00552552472800016,0.00553208775818348,0.00553797790780664,0.00554313324391842,0.00554766040295363,0.00555146159604192,0.00555464252829552,0.00555708399042487,0.00555888703092933,0.00555992824956775,0.00556031381711364,0.00555992824956775,0.00555888703092933,0.00555708399042487,0.00555464252829552,0.00555146159604192,0.00554766040295363,0.00554313324391842,0.00553797790780664,0.00553208775818348,0.00552552472800016,0.00551821896806359,0.00551019050180912,0.00550147471949458,0.00549201155081391,0.00548202730715275,0.00547122210264206,0.00546016823500395,0.00544764194637537,0.00543520553037524,0.00542178330942988,0.00540779717266560,0.00539305759593844,0.00537753105163574,0.00536190019920468,0.00534513592720032,0.00532803731039166,0.00530992168933153,0.00529145309701562,0.00527210766449571,0.00525241391733289,0.00523192156106234,0.00521104829385877,0.00518939504399896,0.00516731571406126,0.00514446385204792,0.00512116774916649,0.00509712658822537,0.00507265469059348,0.00504747871309519,0.00502189761027694,0.00499565014615655,0.00496901245787740,0.00494172982871532,0.00491404812783003,0.00488572614267468,0.00485697947442532,0.00482760230079293,0.00479778554290533,0.00476738158613443,0.00473655480891466,0.00470521813258529,0.00467348005622625,0.00464128935709596,0.00460866745561361,0.00457557942718267,0.00454199779778719,0.00450790720060468,0.00447419332340360,0.00443863216787577,0.00440392829477787,0.00436816038563848,0.00433271517977119,0.00429609837010503,0.00425944291055203,0.00422220071777701,0.00418491195887327,0.00414714356884360,0.00410927413031459,0.00407090689986944,0.00403239345178008,0.00399336963891983,0.00395421450957656,0.00391457835212350,0.00387486722320318,0.00383471907116473,0.00379455066286027,0.00375396921299398,0.00371339474804699,0.00367240631021559,0.00363143184222281,0.00359002966433764,0.00354864820837975,0.00350683252327144,0.00346506666392088,0.00342287984676659,0.00338080571964383,0.00333833065815270,0.00329604768194258,0.00325335212983191,0.00321092060767114,0.00316800503060222,0.00312544335611165,0.00308228214271367,0.00303968228399754,0.00299631315283477,0.00295400852337480,0.00291011668741703,0.00286725582554936,0.00282487273216248,0.00278127146884799,0.00273811141960323,0.00269464123994112,0.00265189493075013,0.00260887923650444,0.00256614456884563,0.00252320826984942,0.00248040445148945,0.00243752682581544,0.00239478098228574,0.00235209893435240,0.00230957893654704,0.00226720655336976,0.00222499505616725,0.00218295189552009,0.00214104214683175,0.00209929421544075,0.00205765641294420,0.00201618182472885,0.00197481806389987,0.00193364149890840,0.00189260160550475,0.00185179221443832,0.00181115593295544,0.00177079136483371,0.00173062458634377,0.00169074663426727,0.00165107252541929,0.00161168223712593,0.00157251046039164,0.00153361610136926,0.00149499706458300,0.00145663029979914,0.00141863315366209,0.00138072879053652,0.00134335225448012,0.00130541180260479,0.00127036077901721,0.00123186816927046,0.00119539198931307,0.00115993840154260,0.00112464418634772,0.00108958012424409,0.00105433282442391,0.00101962720509619,0.000984976999461651,0.000951002817600966,0.000917225959710777,0.000884129083715379,0.000851254211738706,0.000818981905467808,0.000786905176937580,0.000755351502448320,0.000723983335774392,0.000693100970238447,0.000662431004457176,0.000632248178590089,0.000602328160312027,0.000572911638300866,0.000543812348041683,0.000515223422553390,0.000486996257677674,0.000459260045317933,0.000431919761467725,0.000405024475185201,0.000378568482119590,0.000352496019331738,0.000326937646605074,0.000301679014228284,0.000277043582173064,0.000252562953392044,0.000228860953939147,0.000205067466595210,0.000182373449206352,0.000159190880367532,0.000138069211971015,0.000115204777102917,9.15368291316554e-05,7.59589602239430e-05,5.35608705831692e-05,3.37927012878936e-05,1.25088872664492e-05,-6.17332989349961e-06,-2.56168041232741e-05,-4.30660620622803e-05,-6.11819123150781e-05,-7.76831002440304e-05,-9.48790548136458e-05,-0.000110658475023229,-0.000127136823721230,-0.000142244665767066,-0.000158020178787410,-0.000172384694451466,-0.000187389392522164,-0.000200913782464340,-0.000215083331568167,-0.000227700089453720,-0.000241008558077738,-0.000252692261710763,-0.000265156646491960,-0.000275914761004970,-0.000287581380689517,-0.000297429505735636,-0.000308353744912893,-0.000317294849082828,-0.000327541463775560,-0.000335566815920174,-0.000345231412211433,-0.000352310773450881,-0.000361525919288397,-0.000367538945283741,-0.000376496114768088,-0.000381121528334916,-0.000390382687328383,-0.000392851507058367,-0.000405744503950700,-0.000395501352613792,-0.000407818792155013,-0.000424187630414963,-0.000422747252741829,-0.000428156810812652,-0.000427687598858029,-0.000431753345765173,-0.000432172615546733,-0.000435806956375018,-0.000436697184341028,-0.000439959781942889,-0.000440904172137380,-0.000443635712144896,-0.000444298930233344,-0.000446356250904501,-0.000446533842477948,-0.000447849219199270,-0.000447442784206942,-0.000448006554506719,-0.000446985068265349,-0.000446824764367193,-0.000445200741523877,-0.000444366451120004,-0.000442176271462813,-0.000440725998487324,-0.000438015762483701,-0.000436010304838419,-0.000432832690421492,-0.000430334330303594,-0.000426739337854087,-0.000423797959228978,-0.000419815012719482,-0.000416462833527476,-0.000412113149650395,-0.000408404623158276,-0.000403738202294335,-0.000399769196519628,-0.000394742906792089,-0.000390533183235675,-0.000385188817745075,-0.0144708808511496};


float QAM(float *sI, float *sQ){
    
    float total = 0.0;
    float I = 0.0;
    float Q = 0.0;
    
    for ( int i = 0; i < SAMPLE_LENGTH; i+=DEC_FACTOR){
        I = 0.0;
        Q = 0.0;
        for (int j = 0; j < FILTER_LENGTH; j++){
            if(i-j > 0 && i > 0 && j > 0){
                I = I + (sI[ i - j] * LPF[ j ]);
                Q = Q + (sQ[ i - j] * LPF[ j ]);
            }       
        }
        
        total = total + (I*I + Q*Q); 
    
    }

    total = total/3000;
        
    return total;
}

